#include <toad/toad.hh>
#include <toad/dnd/textplain.hh>
#include <toad/dnd/color.hh>
#include <toad/dnd/image.hh>

class TMyWindow:
	public TWindow
{
	public:
		TMyWindow(TWindow*, const string&);
		
		void mouseMDown(int, int, unsigned);
};

class TMyDropSite:
	public TDropSite
{
		typedef TDropSite super;
	public:
		TMyDropSite(TWindow *p):super(p) {}
		TMyDropSite(TWindow *p, const TRectangle &r):super(p,r) {}
			
		void dropRequest(TDnDObject&);
		void drop(TDnDObject&);
};

int ToadMain()
{
	return TMyWindow(NULL,"DnD Experiments").Run();
}

TMyWindow::TMyWindow(TWindow *p, const string& t):
	TWindow(p, t)
{
	bStaticFrame=true;
	new TMyDropSite(this, TRectangle(5,5,310,190));
}

void TMyWindow::mouseMDown(int, int, unsigned modifier)
{
	StartDrag(new TDnDTextPlain("Hello Folks!"), modifier);
}

void TMyDropSite::dropRequest(TDnDObject &drop)
{
	drop.action=ACTION_COPY;
		
	// try to select an image or, when not available, a text
	if (TDnDImage::Select(drop))
		return;
	if (TDnDTextPlain::Select(drop))
		return;
	if (TDnDColor::Select(drop))
		return;
		
	drop.action = ACTION_NONE;
}

void TMyDropSite::drop(TDnDObject &drop)
{
	cout << "dropping " << drop.flatdata.size() << " bytes" << endl;
	if (drop.type)
		cout << "  type: " << drop.type->mime << endl;
	else
		cout << "  type: (unknown)" << endl;

	PDnDImage img = TDnDImage::ConvertData(drop);
	if (img) {
		TPen pen(parent);
		TBitmap *bmp = img->bmp;
		pen.DrawBitmap(drop.x-bmp->Width()/2, drop.y-bmp->Height()/2, bmp);
		return;
	}
	
	PDnDTextPlain txt = TDnDTextPlain::ConvertData(drop);
	if (txt) {
		TPen pen(parent);
		pen.DrawString(drop.x, drop.y, txt->text);
		return;
	}
	
	PDnDColor col = TDnDColor::ConvertData(drop);
	if (col) {
		TPen pen(parent);
		pen.SetColor(col->rgb);
		pen.FillRectangle(5,5,310,190);
	}
}
