/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TFileDialog
#define TFileDialog TFileDialog

#include <toad/dialog.hh>
#include <toad/textfield.hh>

#include <vector>

class TListBox;
class TCheckBox;
class TComboBox;

class TFileDialog: public TDialog
{
	public:
		TFileDialog(TWindow* ,const string&);
		~TFileDialog();
		unsigned GetResult() const;
		const string& GetFilename() const;
		void* GetXtra() const;
		void SetFilename(const string&);
		void AddFileType(const string &name,const string &ext,void *xtra);
		void SetFileType(unsigned);

	protected:
		void create();
		void destroy();
		void paint();
		
		void btnOk();
		void btnAbort();
		void fileSelect(TListBox*);
		void dirSelect(TListBox*);
		void hidden(TCheckBox*);
		void actFileType(TComboBox*);
		
	private:
		unsigned result;
		bool bShowHiddenFiles;
		void LoadDir();
		void ClrDir();
		bool pFilterCompare(const char*);
	
		string currentdir;
		string filter;
		string filename;
		// TTextField *wndFileEdit;
		TListBox *lb_file, *lb_dir;
		TComboBox *cb;
		vector<string> file;
		vector<string> directory;

	public:		
		struct TFileType {
			string name,ext;
			void *xtra;
			TFileType(){};
			TFileType(const string &n,const string &e,void *x)
			{	name=n; ext=e; xtra=x;}
			TFileType(const TFileType &x)
			{
				name	=	x.name;
				ext 	=	x.ext;
				xtra	= x.xtra;
			}
		};
		typedef vector<TFileType> TFTList;
		TFTList filetype;
};

#endif
