/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TGLine
#define TGLine TGLine

#include <toad/gadget.hh>

class TGLine:
	public TGadget
{
	public:
		TGLine();
		TGLine(TGadgetWindow *parent, int x1, int y1, int x2, int y2);
		void paint(TPen &, EPaintType);
		void getShape(TRectangle&);
		
		void translate(int dx, int dy);
		
		double distance(int x, int y);
		bool getHandle(unsigned, TPoint&);
		void translateHandle(unsigned h, int x, int y);

		unsigned mouseLDown(TGadgetEditor*, int, int, unsigned);
		unsigned mouseMove(TGadgetEditor*, int, int, unsigned);
		unsigned mouseLUp(TGadgetEditor*, int, int, unsigned);
		
		TCloneable* clone() { return new TGLine(*this); }

		void store(TOutObjectStream&, ulong);
		void restore(TInObjectStream&, ulong);
		
	protected:
		TPoint p1, p2;
};

#endif
