/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996,97 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/rowcolumn.hh>

//+---------------------------------------------------------------------------+
//| constructor                                                               |
//+---------------------------------------------------------------------------+
TRowColumn::TRowColumn(TWindow *parent, const string &title):
	TWindow(parent, title)
{
	nOrientation = TS_HORIZONTAL;
}

//+---------------------------------------------------------------------------+
//| adjust                                                                    |
//+---------------------------------------------------------------------------+
void TRowColumn::adjust()
{
	resize();
	TWindow *ptr = FirstChild();
	if (nOrientation==TS_VERTICAL && ptr)
	{	
		do
		{
			ptr->SetSize(Width(), TSIZE_PREVIOUS);
			ptr=NextSibling(ptr);
		}while(ptr);
	}
}

//+---------------------------------------------------------------------------+
//| resize                                                                    |
//+---------------------------------------------------------------------------+
void TRowColumn::resize()
{
	int x,y,max,total;
	x=y=max=total=0;
	TRectangle shape;
	
	TWindow* ptr = FirstChild();
	if(!ptr)
		return;

	if (nOrientation == TS_HORIZONTAL)
	{ //+---------------+
		//| TS_HORIZONTAL |
		//+---------------+
		do
		{
			ptr->GetShape(&shape);
			if ( x!=0 && x+shape.w>Width() )		// start a new line for next child if neccesary
			{
				total+=max;
				y+=max;
				x=max=0;
			}
			ptr->SetPosition(x,y);								// place child
			x+=shape.w;														// one step right
			if (shape.h > max)										// determine the maximal height of the current line
				max=shape.h;
			ptr=NextSibling(ptr);
		}while(ptr);
		SetSize(Width(), total+max);
	}
	else
	{ //+-------------+
		//| TS_VERTICAL |
		//+-------------+
		do
		{
			ptr->SetPosition(x,y);	// place child
			ptr->GetShape(&shape);
			y += shape.h;
			if (shape.w > max)
				max = shape.w;
			ptr=NextSibling(ptr);
		}while(ptr);
		SetSize(total+max, y);
	}
}
