/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TScrollBar
#define TScrollBar TScrollBar

#ifndef TControl
#include <toad/control.hh>
#endif

class TSlider;
class TNArrowButton;

class TScrollBar: public TControl, public TIntManipulator
{
		typedef TControl super;
		typedef TScrollBar thisClass;
		friend TNArrowButton;

	protected:
		bool bVertical;

	public:
		TScrollBar(TWindow*, const string&, bool vertical);
		int nMin, nMax, nVisible;
		void SetVisible(int n);
		void SetRange(int min,int max);

		static int FixedSize();

	protected:
		void resize();
    void paint();
		void focus();
		void valueChanged();

		void mouseLDown(int,int,unsigned);
		void mouseLUp(int,int,unsigned);
		void mouseMove(int,int,unsigned);
		void keyDown(TKey,char*,unsigned);

		void _DrawSlider(TPen &pen, TRectangle &r);
		void _DrawArea(TPen&);
		void _PlaceChildren();
		void _PlaceSlider();
		bool _MoveSliderTo(int y);

		TNArrowButton *btn1;
		TNArrowButton *btn2;
		void button1();
		void button2();
		TRectangle rectSlider;
		int nMouseDown;

	public:
		TSignal sigDecrement,sigDrag,sigIncrement,sigPageDecrement, 
						sigPageIncrement,sigToBottom,sigToTop;
};

class TVScrollBar: public TScrollBar
{
		typedef TScrollBar super;
	public:
		TVScrollBar(TWindow *p, const string &t)
		:TScrollBar(p,t,true){};

		template <class T>
		TVScrollBar(TWindow *p, const string &t, T *d)
			:super(p,t,true)
		{
			SetInterface(NewIntInterface(d));
		}
};

class THScrollBar: public TScrollBar
{
		typedef TScrollBar super;
	public:
		THScrollBar(TWindow *p, const string &t)
		:TScrollBar(p,t,false){};
		
		template <class T>
		THScrollBar(TWindow *p, const string &t, T *d)
			:super(p,t,false)
		{
			SetInterface(NewIntInterface(d));
		}
};

#endif
