/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

// implementation is in `select.cc'

#ifndef TSimpleTimer
#define TSimpleTimer TSimpleTimer

#include <toad/types.hh>
#include <sys/time.h>

class TOADBase;

class TSimpleTimer
{
		struct less;
		friend less;
		friend TOADBase;
		struct timeval _interval;
		struct timeval _next;
		bool _running:1;
		bool _executing:1;
	public:
		TSimpleTimer() {
			_running = false;
			_executing = false;
		}
		virtual ~TSimpleTimer();
		virtual void tick()=0;
		void StartTimer(ulong sec, ulong usec=0, bool skip_first=false);
		void StopTimer();
};

#endif
