/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

/*
	rules for closing tooltips:
	- when the pointer leaves the window
	- when a mouse buttons is pressed
	- when a keyboard button is pressed
*/

#include <toad/toad.hh>
#include <toad/simpletimer.hh>

#include <map>

// currently tooltips are only one line of text
//----------------------------------------------
typedef map<TWindow*,string> TTextMap;
static TTextMap textmap;

class TToolTipTimer:
	public TSimpleTimer
{
	public:
		void tick();
};

class TToolTipWindow:
	public TWindow
{
	public:
		TToolTipWindow();
		void paint();
};

static TToolTipTimer timer;
static bool visible = false;
static TWindow *where;
static TToolTipWindow *tooltip_window = NULL;

static string current_text = "This is a tooltip";

void TWindow::SetToolTip(const string &text)
{
	if (text.size()!=0) {
		textmap[this] = text;
		_bToolTipAvailable = true;
	} else {
		if (_bToolTipAvailable) {
			TTextMap::iterator p = textmap.find(this);
			textmap.erase(p);
		}
		_bToolTipAvailable = false;
	}
}

//. This method is called from the message loop when a window has the
//. _bToolTipAvailableFlag set.
void TOADBase::ToolTipOpen(TWindow *wnd)
{
	where = wnd;
	timer.StartTimer(1, 0, true);		// 1s delay
}

void TToolTipTimer::tick()
{
	StopTimer();
	::visible = true;
	if (tooltip_window==NULL)
		tooltip_window = new TToolTipWindow();

	current_text = textmap[where];
	tooltip_window->SetSize(TOADBase::DefaultFont().TextWidth(current_text)+4,
													TOADBase::DefaultFont().Height()+4 );
	TOADBase::PlaceWindow(tooltip_window, TOADBase::PLACE_TOOLTIP, where);

	if (!tooltip_window->IsRealized())	{
		tooltip_window->Create();
	} else {
		tooltip_window->SetVisible(true);
		tooltip_window->RaiseWindow();
	}
}

//. This method is called from the message loop when a reason occured
//. to close an open tooltip
void TOADBase::ToolTipClose()
{
	timer.StopTimer();
	if (::visible) {
		::visible = false;
		if (tooltip_window)
			tooltip_window->SetVisible(false);
	}
}

TToolTipWindow::TToolTipWindow()
	:TWindow(NULL, "TToolTipWindow")
{
	bPopup = true;
	SetBackground(255,255,192);
}

void TToolTipWindow::paint()
{
	TPen pen(this);
	pen.DrawString(2,2, ::current_text);
}
