/*

GBM.C  General Bitmap Code

*/

/*...sincludes:0:*/
#include <stdio.h>
#include <ctype.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "standard.h"
#include "gbm.h"
#include "gbmhelp.h"

/*...vgbm\46\h:0:*/
/*...vgbmhelp\46\h:0:*/
/*...e*/

/*...sentrypoints:0:*/
#include "gbmpgm.h"
#include "gbmppm.h"
#include "gbmbmp.h"
#include "gbmtga.h"
#include "gbmkps.h"
#include "gbmiax.h"
#include "gbmpcx.h"
#include "gbmtif.h"
#include "gbmlbm.h"
#include "gbmvid.h"
#include "gbmgif.h"
#include "gbmxbm.h"
#include "gbmspr.h"
#include "gbmpsg.h"

/*...vgbmpgm\46\h:0:*/
/*...vgbmppm\46\h:0:*/
/*...vgbmbmp\46\h:0:*/
/*...vgbmtga\46\h:0:*/
/*...vgbmkps\46\h:0:*/
/*...vgbmiax\46\h:0:*/
/*...vgbmpcx\46\h:0:*/
/*...vgbmtif\46\h:0:*/
/*...vgbmlbm\46\h:0:*/
/*...vgbmvid\46\h:0:*/
/*...vgbmgif\46\h:0:*/
/*...vgbmxbm\46\h:0:*/
/*...vgbmspr\46\h:0:*/
/*...vgbmpsg\46\h:0:*/

typedef struct
	{
	GBM_ERR (*query_filetype)(GBMFT *gbmft);
	GBM_ERR (*read_header )(char *fn, int fd, GBM *gbm, char *opt);
	GBM_ERR (*read_palette)(int fd, GBM *gbm, GBMRGB *gbmrgb);
	GBM_ERR (*read_data   )(int fd, GBM *gbm, byte *data);
	GBM_ERR (*write       )(char *fn, int fd, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);
	char *  (*err         )(GBM_ERR rc);
	} FT;

static FT fts[] =
	{
	bmp_qft, bmp_rhdr, bmp_rpal, bmp_rdata, bmp_w, bmp_err,
	gif_qft, gif_rhdr, gif_rpal, gif_rdata, gif_w, gif_err,
	pcx_qft, pcx_rhdr, pcx_rpal, pcx_rdata, pcx_w, pcx_err,
	tif_qft, tif_rhdr, tif_rpal, tif_rdata, tif_w, tif_err,
	tga_qft, tga_rhdr, tga_rpal, tga_rdata, tga_w, tga_err,
	lbm_qft, lbm_rhdr, lbm_rpal, lbm_rdata, lbm_w, lbm_err,
	vid_qft, vid_rhdr, vid_rpal, vid_rdata, vid_w, vid_err,
	pgm_qft, pgm_rhdr, pgm_rpal, pgm_rdata, pgm_w, pgm_err,
	ppm_qft, ppm_rhdr, ppm_rpal, ppm_rdata, ppm_w, ppm_err,
	kps_qft, kps_rhdr, kps_rpal, kps_rdata, kps_w, kps_err,
	iax_qft, iax_rhdr, iax_rpal, iax_rdata, iax_w, iax_err,
	xbm_qft, xbm_rhdr, xbm_rpal, xbm_rdata, xbm_w, xbm_err,
	spr_qft, spr_rhdr, spr_rpal, spr_rdata, spr_w, spr_err,
	psg_qft, psg_rhdr, psg_rpal, psg_rdata, psg_w, psg_err,
	};

#define	N_FT	(sizeof(fts) / sizeof(fts[0]))
/*...e*/

/*...sextension:0:*/
static char *extension(char *fn)
	{
	char *dot, *slash;

	if ( (dot = strrchr(fn, '.')) == NULL )
		return NULL;

	if ( (slash = strpbrk(fn, "/\\")) == NULL )
		return dot + 1;

	return ( slash < dot ) ? dot + 1 : NULL;
	}
/*...e*/

/*...sgbm_init:0:*/
GBM_ERR gbm_init(void)
	{
	return GBM_ERR_OK;
	}
/*...e*/
/*...sgbm_deinit:0:*/
GBM_ERR gbm_deinit(void)
	{
	return GBM_ERR_OK;
	}
/*...e*/
/*...sgbm_query_n_filetypes:0:*/
GBM_ERR gbm_query_n_filetypes(int *n_ft)
	{
	*n_ft = N_FT;
	return GBM_ERR_OK;
	}
/*...e*/
/*...sgbm_guess_filetype:0:*/
GBM_ERR	gbm_guess_filetype(char *fn, int *ft)
	{
	int i;
	char *ext = extension(fn);

	if ( ext == NULL )
		ext = "";

	for ( i = 0; i < N_FT; i++ )
		{
		GBMFT	gbmft;
		char	buf[100+1], *s;

		fts[i].query_filetype(&gbmft);
		for ( s  = strtok(strcpy(buf, gbmft.extensions), " \t,");
		      s != NULL;
		      s  = strtok(NULL, " \t,") )
			if ( gbm_same(s, ext, strlen(ext) + 1) )
				{
				*ft = i;
				return GBM_ERR_OK;
				}
		}
	return GBM_ERR_NOT_FOUND;
	}
/*...e*/

/*...sgbm_query_filetype:0:*/
GBM_ERR gbm_query_filetype(int ft, GBMFT *gbmft)
	{
	return (*fts[ft].query_filetype)(gbmft);
	}
/*...e*/
/*...sgbm_read_header:0:*/
GBM_ERR gbm_read_header(char *fn, int fd, int ft, GBM *gbm, char *opt)
	{
	return (*fts[ft].read_header)(fn, fd, gbm, opt);
	}
/*...e*/
/*...sgbm_read_palette:0:*/
GBM_ERR gbm_read_palette(int fd, int ft, GBM *gbm, GBMRGB *gbmrgb)
	{
	return (*fts[ft].read_palette)(fd, gbm, gbmrgb);
	}
/*...e*/
/*...sgbm_read_data:0:*/
GBM_ERR gbm_read_data(int fd, int ft, GBM *gbm, byte *data)
	{
	return (*fts[ft].read_data)(fd, gbm, data);
	}
/*...e*/
/*...sgbm_write:0:*/
GBM_ERR gbm_write(char *fn, int fd, int ft, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt)
	{
	return (*fts[ft].write)(fn, fd, gbm, gbmrgb, data, opt);
	}
/*...e*/
/*...sgbm_err:0:*/
char *gbm_err(GBM_ERR rc)
	{
	int ft;

	switch ( (int) rc )
		{
		case GBM_ERR_OK:
			return "ok";
		case GBM_ERR_MEM:
			return "out of memory";
		case GBM_ERR_NOT_SUPP:
			return "not supported";
		case GBM_ERR_BAD_OPTION:
			return "bad option(s)";
		case GBM_ERR_NOT_FOUND:
			return "not found";
		case GBM_ERR_BAD_MAGIC:
			return "bad magic number / signiture block";
		case GBM_ERR_BAD_SIZE:
			return "bad bitmap size";
		case GBM_ERR_READ:
			return "can't read file";
		case GBM_ERR_WRITE:
			return "can't write file";
		}

	for ( ft = 0; ft < N_FT; ft++ )
		{
		char *s;

		if ( (s = (*fts[ft].err)(rc)) != NULL )
			return s;
		}

	return "general error";
	}
/*...e*/
