/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.5                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/22/95                                             */
/* Description  : all functions for screen-output using ncurses        */
/*                                                                     */
/* Functions    : grav_draw_box()                                      */
/*                grav_draw_main_screen()                              */
/*                                                                     */
/***********************************************************************/

#define SUBPROG

#include <stdio.h>
#include <strings.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <ncurses.h>
#include "defines.h"
#include "screen.h"
#include "misc.h"

int grav_draw_box (int lines, int cols, int starty, int startx, int color)
{
   int count1;
   int count2;

   /*
    * first decrement each parameter
    */
          
   lines--;    cols--;
   startx--;   starty--;

   /*
    * set color and draw upper left corner. if color is set to 0, a box in
    * black on white is drawn. if color is set to -1, the box is drawn 
    * in white on black.
    */

   switch(color)
   {
      case -1: attron(A_REVERSE);
               break;
   
      case  0: break;
   
      default: attron(COLOR_PAIR(color));
               break;
   }
   move(starty,startx);
   addch(ACS_ULCORNER);

   /*
    * next, draw the horizontal line and at last the
    * upper right corner
    */
                               
   for (count1=1;count1<cols;count1++)
   {
      move(starty,startx+count1);
      addch(ACS_HLINE);
   }
   addch(ACS_URCORNER);

   /*
    * draw the left border, the right border and
    * fill the body with blanks
    */
       
   for(count2=1;count2<lines;count2++)
   {
      move(starty+count2,startx);
      addch(ACS_VLINE);
               
      for (count1=1;count1<cols;count1++)
      {
         move(starty+count2,startx+count1);
         addch(' ');
      }                                                   
      addch(ACS_VLINE);
   }

   /* 
    * draw the lower left corner, the lower horizontal line and
    * the lower right corner. at last, set off the color
    */

   move(starty+lines,startx);
   addch(ACS_LLCORNER);
      
   for (count1=1;count1<cols;count1++)
   {
      move(starty+lines,startx+count1);
      addch(ACS_HLINE);
   }
   addch(ACS_LRCORNER);

   switch(color)
   {
      case -1: attroff(A_REVERSE);
               break;
   
      case  0: break;
   
      default: attroff(COLOR_PAIR(color));
               break;
   }

   return(TRUE);
}

int grav_draw_main_screen(int use_color)
{
   struct utsname uts;
   char system[20];

   /*
    * retrieve OS-Name and release for title-screen and store in
    * variable system
    */
             
   uname(&uts);
   sprintf(system," %s %s %s ",uts.sysname,uts.release, "\0");

   /*
    * if you want to use colors (color-display detected by ncurses or
    * colors are forced with -color or -colour) start color-support and
    * initialize colors
    */

   if(use_color == TRUE)
   {
      grav_init_colors();
      attron(COLOR_PAIR(WHITE_ON_BLUE));
   }

   clear();

   /*
    * draw the boxes on the screen
    */
    
   if (use_color == TRUE)
   {
      grav_draw_box(3,COLS,1,1,BLACK_ON_CYAN);
      grav_draw_box(LINES-3,COLS,4,1,WHITE_ON_BLUE);
      grav_draw_box(LINES-9,47,8,5,BLACK_ON_CYAN);
   }
   else
   {
      grav_draw_box(3,COLS,1,1,COLOR_REVERSE);
      grav_draw_box(LINES-3,COLS,4,1,COLOR_NORMAL);
      grav_draw_box(LINES-9,47,8,5,COLOR_NORMAL);
   }
   
   if (use_color == TRUE)
      attron(COLOR_PAIR(BLACK_ON_CYAN));
   else
      attron(A_REVERSE);

   /*
    * write some text to the top-box
    */
                      
   mvaddstr(0,(COLS-strlen(system))/2,system); 
   mvaddstr(1,2,"GRAphic View 3.5");
   mvaddstr(1,COLS-25,"by Michael Knigge, 1995");

   /*
    * change color and write out some help/infirmation text
    */
                           
   if (use_color == TRUE)
   {
      attroff(COLOR_PAIR(BLACK_ON_CYAN));
      attron(COLOR_PAIR(WHITE_ON_BLUE));
   }
   else
      attroff(A_REVERSE);
                                                         
   mvaddstr(5,5,"Directory of");
   mvaddstr(14,COLS-27,"Press F1 for Help");

   refresh();

   return(TRUE);
}
