/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.5                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/30/95                                             */
/* Description  : all functions for the file-selector                  */
/*                                                                     */
/* Functions    : grav_file_selector()                                 */
/*                grav_draw_selector()                                 */
/*                grav_undraw_selector()                               */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <string.h>
#include <ncurses.h>
#include "standard.h"
#include "gbm.h"
#include "defines.h"
#include "keys.h"
#include "directory.h"
#include "info.h"
#include "misc.h"
#include "selector.h"

int grav_draw_selector(int, int, int, int, DIRTAB []);
int grav_undraw_selector(int, int, int, int, DIRTAB []);


int grav_file_selector(int use_color, int *page, int max_files, int *index, int *count_tagged, DIRTAB dirtab[])
{
   int  key;
   int  line;
   int  rc;
   int  loop_again;
   int  window_flag;
   int  calc_lines;
   int  calc_lines_inc;

   loop_again      = TRUE;
   window_flag     = FALSE;
   calc_lines      = LINES - 12;
   calc_lines_inc  = LINES - 11;
 
   /*
    * here we calculate the line of the file at we will
    * put the selector
    */
   line  = *index - ((*index / calc_lines_inc) * calc_lines_inc);
   
   /*
    * and from here, we will do a loop and get every key pressed....
    */

   rc = DO_HELP;
       
   do
   {
      grav_draw_selector(use_color, line, POS_LEFT, *index, dirtab);
      refresh();
      
      key = getch();
      
      grav_undraw_selector(use_color, line, POS_LEFT, *index, dirtab);

      if (window_flag == FALSE)
      {
         if (use_color)
            attron(COLOR_PAIR(WHITE_ON_BLUE));
         else
            attroff(A_REVERSE);
            
         mvaddstr(LINES-8, COLS-27, "                        ");
         mvaddstr(LINES-7, COLS-27, "                        ");
         mvaddstr(LINES-6, COLS-27, "                        ");
         mvaddstr(LINES-5, COLS-27, "                        ");
         mvaddstr(LINES-4, COLS-27, "                        ");
         window_flag = TRUE;
      }
      
      switch(key)
      {
      case 9:         rc         = DO_INPUT;
                      loop_again = FALSE;
                      break;

      case KEY_F(1):  rc         = DO_HELP;
                      loop_again = FALSE;
                      break;
      
      
      case KEY_m:
      case KEY_M:
      case 43:        rc         = DO_INC_MODE;
                      loop_again = FALSE;
                      break;

      case 45:        rc         = DO_DEC_MODE;
                      loop_again = FALSE;
                      break;
      
      case KEY_i:
      case KEY_I:     if (dirtab[*index].filetype == IS_FILE)
                      {
                         rc         = DO_INFO;
                         loop_again = FALSE;
                      }
                      break;

      case KEY_F(10):
      case KEY_q:
      case KEY_Q:     rc         = DO_QUIT;    
                      loop_again = FALSE;
                      break;

      case KEY_IC:
      case KEY_SPACE: if (dirtab[*index].filetype != IS_DIRECTORY)
                      {
                         if (dirtab[*index].tagged == TRUE)
                         {
                            dirtab[*index].tagged = FALSE;
                            *count_tagged = *count_tagged - 1;
                         }
                         else
                         {
                            dirtab[*index].tagged = TRUE;
                            *count_tagged = *count_tagged + 1;
                         }
                         
                         grav_undraw_selector(use_color, line, POS_LEFT, *index, dirtab);
                      }
                      /*
                       * here we will put _NO_ break!! the fileselector
                       * will be moved one file down if we tagged a file
                       */
                  

      case KEY_DOWN:  
      case      106:                
      case       74:  if (*index + 1 <= max_files - 1)
                      {
                         *index = *index + 1;
                         line++;
                      }
                      if (line > calc_lines)
                      {
                         *page = *page + 1;
                         line = 0;
                         grav_show_directory(use_color, *page, max_files, dirtab);
                      }
                      break;
      
      case KEY_UP:    
      case    107:                
      case     75:    if (*index - 1 >= 0)
                      {
                         *index = *index - 1;
                         line--;
                      }
                      if (line < 0)
                      {
                         *page = *page - 1;
                         line  = calc_lines;
                         grav_show_directory(use_color, *page, max_files, dirtab);
                      }                      
                      break;

      case KEY_NPAGE: *page  = *page  + 1;
                      *index = *index + calc_lines_inc;
                      if (*index >= max_files)
                      {
                         *index = max_files - 1;
                         *page  = *index / calc_lines_inc;
                         line   = *index - ((*index / calc_lines_inc) * calc_lines_inc);
                      }
                      grav_show_directory(use_color, *page, max_files, dirtab);
                      break;
                   
              
      case KEY_PPAGE: *page  = *page  - 1;
                      *index = *index - calc_lines_inc;
                      if (*index < 0)
                      {
                         *index = 0;
                         *page  = 0;
                         line   = 0;
                      }
                      grav_show_directory(use_color, *page, max_files, dirtab);
                      break;

      case KEY_HOME:  *page  = 0;
                      *index = 0;
                      line   = 0;
                      grav_show_directory(use_color, *page, max_files, dirtab);
                      break;

      case KEY_END:   *index = max_files - 1;
                      *page  = *index / calc_lines_inc;
                      line   = *index - ((*index / calc_lines_inc) * calc_lines_inc);
                      grav_show_directory(use_color, *page, max_files, dirtab);
                      break;

      case KEY_ENTER: if (dirtab[*index].filetype == IS_DIRECTORY)
                         rc = DO_CHDIR;
                      else
                      {
                         if (*count_tagged == 0)
                         {
                            *count_tagged         = 1;
                            dirtab[*index].tagged = TRUE;
                         }
                         rc = DO_VIEW;
                      }
                      loop_again = FALSE;
                      break;
      }
   
   }
   while(loop_again == TRUE);

   return(rc);
}

int grav_draw_selector(int use_color, int line, int column, int index, DIRTAB dirtab[])
{

   if (dirtab[index].tagged == FALSE)
   {
      if (use_color)
         attron(COLOR_PAIR(WHITE_ON_BLACK));
      else
         attron(A_NORMAL);
         
      grav_display_entry(line+1, column, index, dirtab);
 
   }
   else
   {
      attron(A_BOLD);
      
      if (use_color)
         attron(COLOR_PAIR(YELLOW_ON_BLACK));
      else
         attron(A_NORMAL);
         
      grav_display_entry(line+1, column, index, dirtab);
      attroff(A_BOLD);
   }

   return(TRUE);
}

int grav_undraw_selector(int use_color, int line, int column, int index, DIRTAB dirtab[])
{

   if (dirtab[index].tagged == FALSE)
   {
      if (use_color)
         attron(COLOR_PAIR(BLACK_ON_CYAN));
      else
         attron(A_REVERSE);
         
      grav_display_entry(line+1, column, index, dirtab);
   }
   else
   {
      attron(A_BOLD);
      
      if (use_color)
         attron(COLOR_PAIR(YELLOW_ON_CYAN));
      else
         attron(A_REVERSE);
         
      grav_display_entry(line+1, column, index, dirtab);
      attroff(A_BOLD);
   }

   if (use_color == FALSE)
      attroff(A_REVERSE);

   return(TRUE);
}

int grav_display_entry(int line, int column, int index, DIRTAB dirtab[])
{
   GBM     gbm;
   GBMFT   gbmft;
   GBMRGB  gbmrgb[256];

   int     col;
   int     error_id;
   char    temp[21];

   
   /*
    * first, erase the current line on the screen
    */
   mvaddstr(line+7, column-1, "                                             ");

   /*
    * if the current filen in dirtab is a directory,
    * we will put this filename in "<" and ">". otherwise
    * we will use the unmodified filename
    */
       
   if (dirtab[index].filetype == IS_DIRECTORY)
   {
      strcpy(temp,"<");
      strncat(temp,dirtab[index].filename,18);
      strcat(temp,">");
   }
   else
   {
      strncpy(temp,dirtab[index].filename,20);
         
      if (dirtab[index].bpp == 0)
      {
         error_id = grav_get_file_info(index, dirtab, &gbm, &gbmft, gbmrgb);
         
         if (error_id == GRAV_NO_ERROR)
         {
            dirtab[index].width  = gbm.w;
            dirtab[index].height = gbm.h;
            dirtab[index].bpp    = gbm.bpp;
         }
         else
         {
            dirtab[index].width  = -1;
            dirtab[index].height = -1;
            dirtab[index].bpp    = -1;
         }
      }
   }
      
   temp[20] = 0;   
   col      = POS_RIGHT;
      
   /*
    * display the filename
    */
   mvaddstr(line+7, POS_LEFT, temp);

         
   /*
    * and now, the get the file informations
    */
   if (dirtab[index].filetype == IS_DIRECTORY)
   {
       sprintf(temp, "[    Directory    ]");
       mvaddstr(line + 7, col+1, temp);
       
   }
   else
   {
      if (dirtab[index].bpp > 0)
         grav_show_mode(POS_LEFT + 30, line + 7, dirtab[index].width, dirtab[index].height, dirtab[index].bpp);
      else
         mvaddstr(line + 7, col+1,"[      Error      ]");
   }
         
   return(TRUE);                     
}

