#!/usr/bin/wish
# ==============================================================================
#    Compact Disc player for the X window system (CDX) v0.6
# 	copyright Oliver Smith (c) 1997
# 
# 	see the README.CDX file for more details
# ==============================================================================
# Tcl/Tk source code
# created using Tcl7.6/Tk4.2, but should run with Tcl7.4/Tk4.0


# ========= homedir variable _may_ need changing according to where you install # ========= CDplay 
set homedir /usr/local/lib/CDX

# ======================= Initialisation and global variables ==================

# = Load external C code from ext.do
catch { load $homedir/ext.so Ext } out

# = Init main window
wm title . "CDX"
wm iconname . "CDX"
wm geometry . 245x60+0+0
wm resizable . false false

# = Load icons
set rpticon [image create bitmap -file $homedir/rpt.xbm -foreground green -background black]
set muteicon [image create bitmap -file $homedir/mute.xbm -foreground green -background black]
set pauseicon [image create bitmap -file $homedir/pause.xbm -foreground green -background black]

# = Set up global variables
set w 1
set a1 "00:00"
set play 21
set stopped 1
set mte 0
set rept 0
set t "Track #$w"
set alt 0
global homedir
global rpticon
global muteicon
global pauseicon
global play
global a1
global w
global seek
global mte
global rept
global stopped
global t
global alt

# = Set up main window
frame .fr1 -bg black -height 56 -width 115
label .fr1.msg -fg green -bg black -textvariable t
button .button1 -bitmap @$homedir/play.xbm -command {Cplay}
button .button4 -bitmap @$homedir/stop.xbm -command {stop}
button .button2 -bitmap @$homedir/trkdn.xbm -command {trackdown}
button .button3 -bitmap @$homedir/trkup.xbm -command {trackup}
button .button5 -text "repeat" -command {rpt} -height 30 -width 50
button .button6 -text "mute" -command {mute} -height 30 -width 50
pack .button1
pack .button4
pack .button3
pack .button2
pack .button5
pack .button6
label .fr1.pos -fg green -bg black -textvariable a1 -font "-adobe-courier-bold-r-normal--24-240-75-75-m-150-iso8859-1"
pack .fr1
pack .fr1.pos
pack .fr1.msg
place .button1 -x 0 -y 0 -height 30 -width 50
place .button4 -x 0 -y 30 -height 30 -width 50
place .fr1 -x 50 -y 2 -height 56 -width 115
place .fr1.pos -x 5 -y 6
place .fr1.msg -x 10 -y 31
place .button3 -x 165 -y 0 -height 30 -width 30
place .button2 -x 165 -y 30 -height 30 -width 30
place .button5 -x 195 -y 0 -height 30 -width 50
place .button6 -x 195 -y 30 -height 30 -width 50


# update track number
set w [CDtrackno]
set t "Track #$w"
if {$w>99} {
	set t "Track #--"
	set a1 "--:--"
	}

# = Get original oudio status
set play [CDaudstat]
# -=[HACK]=- check for pause on start-up
if {$play==18} {
	label .fr1.pauselbl -image $pauseicon -bg black
	pack .fr1.pauselbl
	place .fr1.pauselbl -x 75 -y 30
	}

# = start main status loop
after 1000 {status} 

proc status {} {
# globals
global w
global a1
global play
global rept
global stopped
global t
global alt

# update timer
set a1 [CDtrackpos]

# update status
set play [CDaudstat]
# if the timer > 74 mins then the tray is open
# if it has stopped...
if {$play!=17 && $play!=18} { 
# ..repeat if neccesary
	if {$stopped==0 && $rept==1} {CDplay 1}
	if {$stopped==0 && $rept==0} {
					set stopped 1
					set w 1
					set t "Track #$w"
					}
	if {$alt==1} {
			after 10 {status}
			return 0
			}
	}

# update timer
set a1 [CDtrackpos]
# update track number
set w [CDtrackno]
set t "Track #$w"
if {$w>49} {
	set t "Track #--"
	set a1 "--:--"
	}

# repeat in 10ms
after 1000 {status}
}

# === CD play
proc Cplay {} {
global w
global play
global pauseicon
global stopped
global alt
set alt 0
if {$play==17} {
	label .fr1.pauselbl -image $pauseicon -bg black
	pack .fr1.pauselbl
	place .fr1.pauselbl -x 75 -y 30
	CDpause
	}
if {$play==18} {
	destroy .fr1.pauselbl
	CDunpause
	}
if {$play==21} {CDplay "$w"}
set stopped 0
}
	
# === CD stop
proc stop {} {
global play
global stopped
global t
global w
global t1
global a1
global alt
set alt 0
if {$play==17} {CDstop}
if {$play==18} {
	destroy .fr1.pauselbl
	CDstop
	}
if {$play!=17} {if {$play!=18} {
				CDeject
# update track number
				set w [CDtrackno]
				set t1 "Track #$w"
				set t "Track #--"
				set a1 "--:--"
				set alt 0
				} }
set stopped 1
}

# === Next track
proc trackup {} {
global seek
global w
global play
global mte
global t
global alt
set alt 1
set p $play
set seek 1
set w [expr $w+1]
if {$w>[LastTrack]} { set w [LastTrack]}
set t "Track #$w"
if {$p==17} {CDplay $w}
set seek 0
return $w
}

# === Prev. track
proc trackdown {} {
global seek
global w
global play
global mte
global t
global alt
set alt 1
set p $play
set seek 1
set w [expr $w-1]
if {$w<[FirstTrack]} { set w [FirstTrack]}
set t "Track #$w"
if {$p==17} {CDplay $w}
set seek 0
return $w
}

# === toggle repeat
proc rpt {} {
global rept
global rpticon
set r $rept
if {$r==0} {
	label .fr1.rpticonlbl -image $rpticon -bg black
	pack .fr1.rpticonlbl
	place .fr1.rpticonlbl -x 90 -y 11
	set rept 1
	}
if {$r==1} {
	destroy .fr1.rpticonlbl
	set rept 0
	}
}

# === toggle mute
proc mute {} {
global mte
global muteicon
set r $mte
if {$r==0} {
	label .fr1.muteiconlbl -image $muteicon -bg black
	pack .fr1.muteiconlbl
	place .fr1.muteiconlbl -x 90 -y 36
	set mte 1
	VolOff
	}
if {$r==1} {
	destroy .fr1.muteiconlbl
	set mte 0
	VolOn
	}
}
