// ========================================================================
//   Compact Disc player for the X window system (CDX) v0.6
//      copyright Oliver Smith (c) 1997
//    see README.CDX for more details
// ========================================================================
//   C source code
//   developed using pgcc 2.7.2

#include <fcntl.h>
#include <stddef.h>
#include <stdio.h>
#include <linux/cdrom.h>
#include <linux/soundcard.h>
#include <string.h>
#include "tk.h"

int CDdrive;
int Mixer;
int Volume;
char Trackno;
struct cdrom_tochdr TrackHeader;
struct cdrom_tocentry TrackTable[50];
char firsttrack[3];
char lasttrack[3];
char status[9];
char tr[3];
char astat[3];

char GetTrackTable()
{
  char i;
  
  ioctl(CDdrive, CDROMREADTOCHDR, &TrackHeader);

  i=0;
  if(TrackHeader.cdth_trk0>9)
    {
      i=1;
      firsttrack[0]=TrackHeader.cdth_trk0/10 + 0x30;
    }
  firsttrack[i]=TrackHeader.cdth_trk0%10 + 0x30;
  firsttrack[i+1]=0;
 
  i=0;
  if(TrackHeader.cdth_trk1>9)
    {
      i=1;
      lasttrack[0]=TrackHeader.cdth_trk1/10 + 0x30;
    }
  lasttrack[i]=TrackHeader.cdth_trk1%10 + 0x30;
  lasttrack[i+1]=0;
  
  for(i=TrackHeader.cdth_trk0;i<TrackHeader.cdth_trk1+1;i++)
    {
      TrackTable[i].cdte_track=i;
      TrackTable[i].cdte_format=CDROM_MSF;
      ioctl(CDdrive, CDROMREADTOCENTRY, &TrackTable[i]);
    }
  return(1);
}

char CDopen()
{
  struct cdrom_volctrl vol;
  CDdrive=open("/dev/cdrom", O_RDONLY);
  if(CDdrive == -1)
    {
      printf("CD open failed\nMake sure /dev/cdrom is present\n");
      return(0);
    }
  vol.channel0=255;
  vol.channel1=255;
  vol.channel2=255;
  vol.channel3=255;
  if(ioctl(CDdrive, CDROMVOLCTRL, &vol)==-1)
    {
      printf("CD init failed\n");
      close(CDdrive);
      return(0);
    }
  Mixer=open("/dev/mixer", O_RDONLY);
  if(Mixer == -1)
    printf("Unable to open mixer at /dev/mixer\nvolume controls will not be available\n");
  return(1);
}

CDclose()
{
  close(CDdrive);
  if(Mixer != -1)
    close(Mixer);
}

static int CDplay(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  struct cdrom_msf msf;
  char z;
  int i=0;
  
  if(!argc) return;
  for(z=0;z<strlen(argv[1]);z++)
    {
      i*=10;
      i+=argv[1][z]-0x30;
    }
  if(i==1) if(TrackTable[i].cdte_ctrl & CDROM_DATA_TRACK) i++;
  if(i>TrackHeader.cdth_trk1) return TCL_OK;
  msf.cdmsf_min0=TrackTable[i].cdte_addr.msf.minute;
  msf.cdmsf_sec0=TrackTable[i].cdte_addr.msf.second;
  msf.cdmsf_frame0=TrackTable[i].cdte_addr.msf.frame;
  msf.cdmsf_min1=CD_MINS;
  msf.cdmsf_sec1=CD_SECS;
  msf.cdmsf_frame1=CD_FRAMES-1;
  
  if(ioctl(CDdrive, CDROMPLAYMSF, &msf) == -1)
    {
      printf("Error Playing Track\n");
      return(0);
    }
  return(TCL_OK);
}

static int CDstop(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  ioctl(CDdrive, CDROMSTOP);
  return TCL_OK;
}

static int CDpause(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  ioctl(CDdrive, CDROMPAUSE);
  return TCL_OK;
}

static int CDunpause(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  ioctl(CDdrive, CDROMRESUME);
  return TCL_OK;
}

static int CDeject(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  ioctl(CDdrive, CDROMEJECT);
  return TCL_OK;
}

static int CDtrackpos(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  struct cdrom_subchnl s;
  s.cdsc_format=CDROM_MSF;
  ioctl(CDdrive, CDROMSUBCHNL, &s);
  status[0]=s.cdsc_reladdr.msf.minute/10 + 0x30;
  status[1]=s.cdsc_reladdr.msf.minute%10 + 0x30;
  status[2]=':';
  status[3]=s.cdsc_reladdr.msf.second/10 + 0x30;
  status[4]=s.cdsc_reladdr.msf.second%10 + 0x30;
  status[5]=0;
  interp->result=status;
  return TCL_OK;
}

static int CDtrackno(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  struct cdrom_subchnl s;
  char i=0;
  GetTrackTable();
  s.cdsc_format=CDROM_MSF;
  if(ioctl(CDdrive, CDROMSUBCHNL, &s)==-1)
	s.cdsc_trk=0xff;
  if(s.cdsc_trk>9)
    i=1;
  if(i)
    tr[0]=s.cdsc_trk/10 + 0x30;
  tr[i]=s.cdsc_trk%10 + 0x30;
  tr[i+1]=0;
  interp->result=tr;
  return TCL_OK;
}

static int CDaudstat(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  struct cdrom_subchnl s;
  char i=0;
  s.cdsc_format=CDROM_MSF;
  ioctl(CDdrive, CDROMSUBCHNL, &s);
  if(s.cdsc_audiostatus>9)
    i=1;
  if(i)
    astat[0]=s.cdsc_audiostatus/10 + 0x30;
  astat[i]=s.cdsc_audiostatus%10 + 0x30;
  astat[i+1]=0;
  interp->result=astat;
  return TCL_OK;
}



char MixerVolume(vol)
    int vol;
{
  int i=4;
  if(ioctl(Mixer, SOUND_MIXER_WRITE_CD, &vol)==-1)
    {
      printf("Unable to set CD volume level\n");
      return(0);
    }
 Volume=vol;
  return(1);
}

static int VolOff()
{
  MixerVolume(0);
  return TCL_OK;
}

static int VolOn()
{
  MixerVolume(0xffff);
  return TCL_OK;
}

static int FirstTrack(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  interp->result=firsttrack;
  return TCL_OK;
}

static int LastTrack(ClientData CD, Tcl_Interp *interp, int argc, char **argv)
{
  interp->result=lasttrack;
  return TCL_OK;
}

int
Ext_Init(interp)
    Tcl_Interp *interp;
{
  if(!CDopen())
    return;
  if(!GetTrackTable())
    return;
  MixerVolume(0xffff);	
  Trackno=1;
  Tcl_CreateCommand(interp, "CDplay", CDplay, NULL, NULL);
  Tcl_CreateCommand(interp, "CDstop", CDstop, NULL, NULL);
  Tcl_CreateCommand(interp, "CDpause", CDpause, NULL, NULL);
  Tcl_CreateCommand(interp, "CDunpause", CDunpause, NULL, NULL);
  Tcl_CreateCommand(interp, "CDeject", CDeject, NULL, NULL); 
  Tcl_CreateCommand(interp, "CDaudstat", CDaudstat, NULL, NULL);
  Tcl_CreateCommand(interp, "CDtrackpos", CDtrackpos, NULL, NULL);
  Tcl_CreateCommand(interp, "CDtrackno", CDtrackno, NULL, NULL);
  Tcl_CreateCommand(interp, "FirstTrack", FirstTrack, NULL, NULL);
  Tcl_CreateCommand(interp, "LastTrack", LastTrack, NULL, NULL);
  Tcl_CreateCommand(interp, "VolOn", VolOn, NULL, NULL);
  Tcl_CreateCommand(interp, "VolOff", VolOff, NULL, NULL);
  return TCL_OK;
}
 
