// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _PrefsWindow_H_
#define _PrefsWindow_H_

#include <qwidget.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qcombo.h>
#include "xcd.h"
#include "Cdrom.h"

//: Window for modifying user preferences.
//. Provide an interface for viewing, modifying, and saving default user
//. preferences.
class PrefsWindow : public QWidget {
    Q_OBJECT
    QCheckBox*  _autoPlay;
    QCheckBox*  _autoEject;
    QCheckBox*  _shuffle;
    QCheckBox*  _repeat;
    QComboBox*  _timeMode;
    QComboBox*  _iconMode;
	QComboBox*  _cdromType;
    QLineEdit*  _pollTime;
    QLineEdit*  _devicePath;
    QLineEdit*  _dbasePath;

    // Dont let the compiler create these...
    PrefsWindow(const PrefsWindow& prefsWindow);
    PrefsWindow& operator=(const PrefsWindow& prefsWindow);
public:
    //: Create a PrefsWindow.
    PrefsWindow(QWidget* parent = 0, const char* name = 0);

private slots:
    // Emit updateAutoPlay.
    void doUpdateAutoPlay();

    // Emit updateAutoEject.
    void doUpdateAutoEject();

    // Emit updatePlayMode.
    void doUpdateShuffle();

    // Emit updateRepeatMode.
    void doUpdateRepeat();

    // Emit updateTimeMode.
    void doUpdateTimeMode();

    // Emit updateIconMode.
    void doUpdateIconMode();

	void doUpdateCdromType();

    // Emit updatePollTime.
    void doUpdatePollTime();

    // Emit updateDevicePath.
    void doUpdateDevicePath();

    // Emit updateDbasePath.
    void doUpdateDbasePath();
public slots:
    //: Hide the prefs window.
    void dismiss();

    void changeShuffle();
    void changeRepeat();
    void changeTimeMode();
    void changeIconMode();
};

extern PrefsWindow* prefsWindow;

#endif
