// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _ScsiCdrom_h_
#define _ScsiCdrom_h_

#include "../CdromBase.h"

class ScsiCdrom : public CdromBase {
    int  _volume;
    bool _paused;
 public:
	ScsiCdrom();
	
	//: Eject/retract the drive tray.
	virtual bool eject( int fd );
	
	//: Return the ID of the current disc, or NULL is no disc is present.
	virtual CompactDiscID* id( int fd );
	
	virtual bool init( int fd );
	
	//: Pause the playing disc.
	virtual bool pause( int fd );
	
	//: Play a single, specific track on the disc.
	virtual bool play( int fd, int track );
	
	//: Resume playing the disc after pausing.
	virtual bool resume( int fd );

	//: Get the current status of the CDROM drive.
	virtual bool status( int fd, CdromStatus& status, int& absTime, int& volume );
	
	//: Stop the playing disc.
	virtual bool stop( int fd );
	
	//: Set the output volume of the CDROM drive.
	virtual bool volume( int fd, int vol );
};

#endif
