// XCd - An X11 CD Player
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

extern "C" {
#include <unistd.h>
#include <fcntl.h>
}
#include "../Cdrom.h"
#include "IdeCdrom.h"
#include "ScsiCdrom.h"
#include "../Options.h"

Cdrom::Cdrom() : _fd( -1 ), _cdrom( 0 )
{
	_typeConstants[ GenericIde ]  = "GenericIde";
	_typeConstants[ GenericScsi ] = "GenericScsi";
	_typeConstants[ NecCdr260 ]   = "NecCdr260";
	
	_typeNames[ GenericIde ]  = "Generic IDE";
	_typeNames[ GenericScsi ] = "Generic SCSI";
	_typeNames[ NecCdr260 ]   = "NEC CDR-260";
}

Cdrom::~Cdrom()
{
	delete _cdrom;
}

bool Cdrom::eject()
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->eject( _fd );
	} else {
		return false;
	}
}

CompactDiscID* Cdrom::id()
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->id( _fd );
	} else {
		return 0;
	}
}

bool Cdrom::pause()
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->pause( _fd );
	} else {
		return false;
	}
}

bool Cdrom::play( int track )
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->play( _fd, track );
	} else {
		return false;
	}
}

bool Cdrom::resume()
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->resume( _fd );
	} else {
		return false;
	}
}

bool Cdrom::status( CdromStatus& status, int& absTime, int& volume )
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->status( _fd, status, absTime, volume );
	} else {
		return false;
	}
}

bool Cdrom::stop()
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->stop( _fd );
	} else {
		return false; 
	}
}

bool Cdrom::volume( int vol )
{
	if ( _cdrom && ( _fd >= 0 ) ) {
		return _cdrom->volume( _fd, vol );
	} else {
		return false;
	}
}

void Cdrom::changeType()
{
	if ( _cdrom ) {
		delete _cdrom;
		_cdrom = 0;
	}
	
	switch ( options->cdromType() ) {
	 case GenericIde:
	 case NecCdr260:
		_cdrom = new IdeCdrom;
		break;
		
	 case GenericScsi:
		_cdrom = new ScsiCdrom;
		break;
		
	 case MaxCdromTypes:
		break;
	}
	
	if ( _cdrom ) {
		_cdrom->init( _fd );
	}
}

void Cdrom::changePath()
{
	if ( _fd >= 0 ) {
		close( _fd );
	}
	_fd = open( options->cdromPath(), O_RDONLY );
}
