/* $Header: /wwg/motif/xltcdplay/RCS/cdrom.h,v 1.3 1997/01/30 04:23:21 wwg Rel $
 * Warren W. Gay VE3WWG		Sat Jan 18 13:09:10 1997
 *
 * CDROM INTERFACE HEADER:
 *
 * 	X LessTif CD Play :
 * 
 * 	Copyright (C) 1997  Warren W. Gay VE3WWG
 * 
 * This  program is free software; you can redistribute it and/or modify it
 * under the  terms  of  the GNU General Public License as published by the
 * Free Software Foundation version 2 of the License.
 * 
 * This  program  is  distributed  in  the hope that it will be useful, but
 * WITHOUT   ANY   WARRANTY;   without   even  the   implied   warranty  of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details (see enclosed file COPYING).
 * 
 * You  should have received a copy of the GNU General Public License along
 * with this  program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * Send correspondance to:
 * 
 * 	Warren W. Gay VE3WWG
 * 	5536 Montevideo Road #17
 *	Mississauga, Ontario L5N 2P4
 * 
 * Email:
 * 	wwg@ica.net			(current ISP of the month :-) )
 * 	bx249@freenet.toronto.on.ca	(backup)
 *
 * $Log: cdrom.h,v $
 * Revision 1.3  1997/01/30 04:23:21  wwg
 * Ready for Beta release.
 *
 * Revision 1.2  1997/01/26 05:06:06  wwg
 * Now includes FF and FB capability. Much was restructured
 * to make this possible.
 *
 * Revision 1.1  1997/01/20 04:39:34  wwg
 * Initial revision
 *
 */
#ifndef _cdrom_h_
#define _cdrom_h_ "@(#)cdrom.h $Revision: 1.3 $"

#ifndef CDROM_PATHNAME		// If not defined in makefile then use..
#define CDROM_PATHNAME		"/dev/cdrom"
#endif

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <linux/cdrom.h>
#include <linux/ucdrom.h>

typedef struct cdrom_tochdr	CD_TOC_Hdr;
typedef struct cdrom_tocentry	CD_TOC_Entry;
typedef struct cdrom_subchnl	CD_SubCh;
typedef struct cdrom_volctrl	CD_Vol;
typedef struct cdrom_msf0	CD_MSF;

#define N_TOC_ENTRIES	200				// Max # of CD tracks

// These have not been confirmed, as to which one is which:
// If you know for fact (and can point to proof), please email me
// and I'll fix this once and for all. email to wwg@ica.net or bx249@freenet.toronto.on.ca

#define LEFTCH		channel0			// Left CD channel?
#define RIGHTCH		channel1			// Right CD channel?

class CDROM {
	int		fd;				// Open file descriptor
	char		*devicePath;			// eg. "/dev/cdrom"
	CD_TOC_Hdr	toc_hdr;
	unsigned	cEntries;			// Number of valid entries
	struct {
		CD_TOC_Entry	cdtoc;			// CD TOC entry
		unsigned	startf;			// Start location in frames
		unsigned	lengthf;		// length in frames
		char		bDataTrack;		// True if this is a data track
		char		bSuppress;		// True if this track is not to be played
	} info[N_TOC_ENTRIES];
	CD_MSF		cdend;				// End MSF time
	CD_SubCh	subch;
	CD_Vol		vol;				// Volume level
	char		pos[10];			// Trk min:sec  "99 99:99"

	unsigned _getState()		throw (char *);
	void _getVol()			throw (char *);
	void _setVol()			throw (char *);
	unsigned _stop()		throw (char *);
public:	
	CDROM();
	~CDROM();
	void open(const char *pathname)	throw (char *);
	void close()			throw (char *);
	void eject()			throw (char *);
	void play(unsigned track)	throw (char *);
	void play(int seconds)		throw (char *);
	void stop()			throw (char *);
	void pause()			throw (char *);
	void reset()			throw (char *);
	void reset(const char *pathname) throw (char *);
	void setTrack(unsigned trackNo)	throw (char *);
	unsigned getTrack()		throw (char *);
	unsigned getTracks()		throw (char *);
	unsigned getLeftVol()		throw (char *);
	void getProgress(unsigned *pTrk,unsigned *pCD) throw(char *);
	void setLeftVol(unsigned level) throw (char *);
	unsigned getRightVol()		throw (char *);
	void setRightVol(unsigned level) throw (char *);
	char *getPos()			throw (char *);
	void getTrackMSF(unsigned track,unsigned *pMin,unsigned *pSec,unsigned *pFrame) throw(char *);
	void getCDMSF(unsigned *pMin,unsigned *pSec,unsigned *pFrame) throw(char *);
	int isPlaying()			throw (char *);
	int isOpen();
	int isDataTrack(unsigned track) throw (char *);
	unsigned getDataTracks()        throw (char *);
};

#endif /* _cdrom_h_ */

/* $Source: /wwg/motif/xltcdplay/RCS/cdrom.h,v $ */
