/* $Header: /wwg/motif/xltcdplay/RCS/xltcdplay.cpp,v 1.7 1997/02/03 01:12:07 wwg Exp $
 * Warren W. Gay VE3WWG		Wed Jan 15 21:33:53 1997
 *
 * 	X LessTif CD Play :
 * 
 * 	Copyright (C) 1997  Warren W. Gay VE3WWG
 * 
 * This  program is free software; you can redistribute it and/or modify it
 * under the  terms  of  the GNU General Public License as published by the
 * Free Software Foundation version 2 of the License.
 * 
 * This  program  is  distributed  in  the hope that it will be useful, but
 * WITHOUT   ANY   WARRANTY;   without   even  the   implied   warranty  of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details (see enclosed file COPYING).
 * 
 * You  should have received a copy of the GNU General Public License along
 * with this  program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * Send correspondance to:
 * 
 * 	Warren W. Gay VE3WWG
 * 	5536 Montevideo Road #17
 *	Mississauga, Ontario L5N 2P4
 * 
 * Email:
 * 	wwg@ica.net			(current ISP of the month :-) )
 * 	bx249@freenet.toronto.on.ca	(backup)
 *
 * NOTE!!! NOTE!!! NOTE!!! NOTE!!! NOTE!!! NOTE!!! NOTE!!! NOTE!!! NOTE!!!!
 * 
 *     *** *** NOT ALL CD-ROM DRIVES SUPPORT VOLUME CONTROL *** ***
 * 
 * There are probably a number of CD-ROM drive models out there that do NOT
 * support  the  volume control  option.  I read some comments in the LINUX
 * kernel  code  to  suggest  that  a number of other drives support either
 * crude volume levels, or in other cases just an ON and OFF level.  I have
 * not tested with these units.
 * 
 * If your drive is one of these, then there is nothing the software can do
 * to enhance  this! In  other words, don't ask me why your volume does not
 * work  right, nor  don't expect a fix for it.  If your drive behaves this
 * way, then  you'll need  to control the volume on your audio card's mixer
 * panel (see below).
 * 
 * Your  sound  card may support another set of volume controls in addition
 * to  the  drive's  volume controls  (which you may  be using presently in
 * another application).  This  application does not access, nor assume the
 * presence  of  a  sound  card (theoretically, you could just be using the
 * CD-ROM  drive's line output to a real amplifier, for real sound, and not
 * use a sound card at all)
 * 
 * 		    *** IF YOU GET NO VOLUME ***
 * 
 * Many of you will have your CD-ROM drives plugged into your sound card (I
 * happen  to  use  a  SoundBlaster-16). Even  with a working CD-ROM volume
 * control,  it is possible that your sound card's mixer settins are turned
 * down (or OFF)  for your CD input (also check the cabel between the CDROM
 * and  the  sound card.)
 * 
 * If  your CDROM drive supports proper volume controls then fix your sound
 * card's  audio  volume  level at the maximum CD output you want (maybe at
 * max?), and  then  try adjusting your xltcdplay volume levels.  Once your
 * sound  card is  set up, your  CD  volume can  be  entirely controlled by
 * xltcdplay.
 * 
 * If  your CDROM drive has crippled volume controls (or none at all), then
 * you'll  want  to use  your sound mixer application to control the volume
 * separately from xltcdplay (sorry).
 * 
 * $Log: xltcdplay.cpp,v $
 * Revision 1.7  1997/02/03 01:12:07  wwg
 * Sigh.. removed some dead comment lines
 *
 * Revision 1.6  1997/02/03 01:09:20  wwg
 * Fixed RCS substitution problem in vers[] string.
 *
 * Revision 1.5  1997/02/02 04:37:48  wwg
 * Fixed the version number handling, so its properly edited into
 * the title bar, and into the Help->About dialog box.
 *
 * Revision 1.4  1997/01/30 04:21:58  wwg
 * A number of enhancements: now ready for beta release?
 *
 * Revision 1.3  1997/01/26 05:05:41  wwg
 * Many changes, but now all complete except for the
 * progress indicators.
 *
 * Revision 1.2  1997/01/20 05:23:25  wwg
 * Source code cleanup to prepare for release.
 *
 * Revision 1.1  1997/01/20 04:37:57  wwg
 * Initial revision
 */
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/ArrowB.h>
#include <Xm/CascadeB.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/MessageB.h>
#include <Xm/ScrollBar.h>
#include <Xm/RowColumn.h>
#include "xltcdplay.h"
#include "cdrom.h"

static char *rcsid[] = { "@(#)xltcdplay.cpp $Revision: 1.7 $", _xltcdplay_h_ };

// BUTTONS:

#define N_BUTROWS		2				// 2 rows of buttons
#define N_BUTCOLS		10				// of 10 buttons each
#define Button_LeftArrow	19				// Left arrow button
#define Button_RightArrow	20				// Right arrow button
#define Button_Eject		21				// Eject button
#define Button_Stop		22				// Stop button
#define Button_Pause		23				// Pause button
#define Button_FB		24				// << Button
#define Button_FF		25				// >> Button
#define Button_Play		26				// Play button

// STATIC FUNCTION PROTOTYPES:

static void StartTimerT1();
static void StartTimerT2(int seconds);
static void ReportError(const char *ErrMsg,unsigned lno);
static void FF_CB(XtPointer client_data,XtIntervalId *timer_idp);
static void ShowVol(int bReportErrors);

// FALLBACK RESOURCES :

static String fallback_resources[] = {
	// General stuff:
	"XLTCDPlay.geometry: +450+350",
	"XLTCDPlay.*foreground: white",
	"XLTCDPlay.*fontList: *helvetica-bold-r-normal--14*",

	"XLTCDPlay.main.menubar.spacing: 10",
	"XLTCDPlay.main.menubar*foreground: black",
	"XLTCDPlay.main.menubar.filemenucascade.labelString: File",
	"XLTCDPlay*filemenu.exit.labelString: Exit",
	"XLTCDPlay.main.menubar.helpmenucascade.labelString: Help",
	"XLTCDPlay*helpmenu.about.labelString: About",

	"XLTCDPlay.main.form.row0.entryBorder: 0",
	"XLTCDPlay.main.form.row0.marginHeight: 6",
	"XLTCDPlay.main.form.row0.marginWidth: 6",
	"XLTCDPlay.main.form.row0.adjustLast: True",
	"XLTCDPlay.main.form.row0.packing: XmPACK_COLUMN",
	"XLTCDPlay.main.form.row0.numColumns: 2",

	// Track Selection Buttons:
	// "XLTCDPlay.main.form.row0.01.marginLeft: 8",
	// "XLTCDPlay.main.form.row0.01.marginRight: 8",
	"XLTCDPlay.main.form.row0*marginLeft: 8",
	"XLTCDPlay.main.form.row0*marginRight: 8",

	// Left Arrow Track Select:
	// "XLTCDPlay.main.form.row0.leftArrow.marginLeft: 8",
	// "XLTCDPlay.main.form.row0.leftArrow.marginRight: 8",
	// Right Arrow Track Select:
	// "XLTCDPlay.main.form.row0.rightArrow.marginLeft: 8",
	// "XLTCDPlay.main.form.row0.rightArrow.marginRight: 8",

	// wRowColVol
	"XLTCDPlay.main.form.volume.marginHeight: 6",
	"XLTCDPlay.main.form.volume.marginWidth: 6",

	// "Left" volume scroll bar:
	"XLTCDPlay.main.form.volume.left.height: 150",
	"XLTCDPlay.main.form.volume.left.increment: 1",
	"XLTCDPlay.main.form.volume.left.pageIncrement: 16",
	"XLTCDPlay.main.form.volume.left.processingDirection: XmMAX_ON_TOP",

	// "Right" volume scroll bar:
	"XLTCDPlay.main.form.volume.right.height: 150",
	"XLTCDPlay.main.form.volume.right.increment: 1",
	"XLTCDPlay.main.form.volume.right.pageIncrement: 16",
	"XLTCDPlay.main.form.volume.right.processingDirection: XmMAX_ON_TOP",

	// Row:
	"XLTCDPlay.main.form.row.marginHeight: 6",
	"XLTCDPlay.main.form.row.marginWidth: 6",
	"XLTCDPlay.main.form.row.entryBorder: 0",
	"XLTCDPlay.main.form.row.numColumns: 1",
	"XLTCDPlay.main.form.row.packing: XmPACK_TIGHT",

	// Track Display Window:
	"XLTCDPlay.main.form.row.trackWindow.background: black",
	"XLTCDPlay.main.form.row.trackWindow.foreground: red",
	"XLTCDPlay.main.form.row.trackWindow.topShadowColor: white",

	// Error Dialog Box: (when toggled on)
	"XLTCDPlay.ErrDlg.dialogTitle: Reported Error",
	"XLTCDPlay.ErrDlg.messageAlignment: XmALIGNMENT_BEGINNING",
	"XLTCDPlay.ErrDlg.okLabelButtons: OK",
	"XLTCDPlay.ErrDlg_popup.dialogTitle: Reported Error",
	"XLTCDPlay.ErrDlg_popup.messageAlignment: XmALIGNMENT_BEGINNING",
	"XLTCDPlay.ErrDlg_popup.okLabelButtons: OK",

	// Row2:
	"XLTCDPlay.main.form.row2.marginHeight: 6",
	"XLTCDPlay.main.form.row2.marginWidth: 6",
	"XLTCDPlay.main.form.row2.entryBorder: 0",
	"XLTCDPlay.main.form.row2.numColumns: 1",
	"XLTCDPlay.main.form.row2.entryAlignment: XmALIGNMENT_CENTER",
	"XLTCDPlay.main.form.row2.packing: XmPACK_COLUMN",

	// Eject, Stop, Pause and Play buttons:
	"XLTCDPlay.main.form.row2.Eject.labelString: Eject",
	"XLTCDPlay.main.form.row2.Stop.labelString:  Stop",
	"XLTCDPlay.main.form.row2.Pause.labelString: Pause",
	
	"XLTCDPlay.main.form.row2.fb.labelString: <<",
	"XLTCDPlay.main.form.row2.ff.labelString: >>",
	"XLTCDPlay.main.form.row2.Play.labelString: Play",

	// wProgRowCol:
	"XLTCDPlay.main.form.progrowcol.marginHeight: 6",
	"XLTCDPlay.main.form.progrowcol.marginWidth: 6",
	"XLTCDPlay.main.form.progrowcol.entryBorder: 0",

	"XLTCDPlay.main.form*trkproglbl.foreground: black",
	"XLTCDPlay.main.form*cdproglbl.foreground: black",

	// Copyright notice: adjust font to suit
	"XLTCDPlay*AboutDlg.fontList: -adobe-helvetica-medium-r-normal-*-10-100-75-75-p-*-iso8859-1",
	"XLTCDPlay*AboutDlg.foreground: black",
	NULL
};

// WIDGETS :

Widget wParent;						// Parent shell widget
XtAppContext aContext;					// Application context

Widget wMain;						// Main widget
Widget wMenuBar;					// Main menu bar
Widget wFileMenuCascade;				// Cascade button for File Menu
Widget wFileMenu;					// File menu itself
Widget wExit;						// File->Exit

Widget wHelpMenuCascade;				// Cascade button for Help Menu
Widget wHelpMenu;					// Help menu itself
Widget wAbout;						// Help->About

Widget wForm;						// Form widget
Widget wRow0;						// Row for Track Buttons
Widget wTracks[N_BUTROWS][N_BUTCOLS];			// Track selection buttons
Widget wErrTgl;						// Error Dialog Toggle Button

unsigned trackNo = 1;					// Current selected track (from buttons)
unsigned bForceReport = 0;				// True to force ErrorReport()

Widget wTrackWindow;					// Track Display Window
Widget wEject;						// Eject button
Widget wStop;						// Stop Button
Widget wPause;						// Pause Button
Widget wFB;						// << Button
Widget wFF;						// >> Button
Widget wPlay;						// Play Button
Widget wErrDlg;						// Error Dialog Box
XmString sErrDlgTitle;					// Title for the Error Dialog Box
Widget wRowColVol;					// Row/Col for scroll bars
Widget wLeftVolSB;					// Volume scroll bar (Left)
Widget wRightVolSB;					// Volume scroll bar (Right)
Widget wRow;
Widget wRow2;

Widget wProgRowCol;					// Progress Row/Col container
Widget wTrackProgress;					// Track progress indicator
XmString sTrackProgress;				// String for Track progress label
Widget wTrackProgLbl;					// Track progress label

Widget wAboutDlg;					// About Dialog Box
XmString sAboutDlgTitle;				// About Dialog Title String
XmString sAboutDlgMessage;				// About Dialog message and copyright

Boolean bReportErrs = TRUE;				// Default initially is to report errors

#define NoTMR	0UL					// Value for "no timer"

XtIntervalId t1 = NoTMR;				// Display update timeout
XtIntervalId t2 = NoTMR;				// FF/FB timer

CDROM  cd;						// CDROM management object

static char vers[] = "$Revision: 1.7 $";			// This gets edited at startup

static void
EditVersionInit() {
	char buf[40], *cp;
	char *dp = buf;

	if ( (cp = strchr(vers,' ')) == NULL )
		return;					// bail out if we don't find the space
	for ( ++cp; *cp && *cp != ' ' && *cp != '$'; )
		*dp++ = *cp++;				// Copy only the version number
	*dp = 0;					// NUL terminate
	strcpy(vers,buf);				// Copy edited version back
}

/*
 * This function returns a copy of pString, which is copied to pBuffer. Any occurance
 * of '$' is replaced with a version number.
 */ 
static char *
EditVersion(char *pString,char *pBuffer) {
	char *bp = pBuffer;

	for ( ; *pString; ++pString )
		if ( *pString == '$' ) {
			strcpy(bp,vers);
			bp += strlen(vers);
		} else	*bp++ = *pString;
	*bp = 0;

	return pBuffer;
}

// Error dialogs toggle value changed callback:

static void
ErrTglChgCB(Widget w,XtPointer client_data,XtPointer call_data) {
	Arg al[4];
	Cardinal ac;

	ac = 0;
	XtSetArg(al[ac],XmNset,&bReportErrs); ++ac;			// Get Error Dialog Toggle
	XtGetValues(wErrTgl,al,ac);					// To see if we report or not..
}

static void
AboutDlgOkCB(Widget w,XtPointer client_data,XtPointer call_data) {
	if ( XtIsManaged(wAboutDlg) )
		XtUnmanageChild(wAboutDlg);
}

static void
AboutCB(Widget w,XtPointer client_data,XtPointer call_data) {
	fprintf(stderr,"Copyright (C) 1997 Warren W. Gay VE3WWG\n");

	if ( XtIsManaged(wAboutDlg) )
		return;							// The dialog is already in use

	XtVaSetValues(wAboutDlg,XmNmessageString,sAboutDlgMessage,NULL);
	XtManageChild(wAboutDlg);					// Make it pop up
}

// Menu: File->Exit

static void
ExitCB(Widget w,XtPointer client_data,XtPointer call_data) {
	try	{
		cd.close();
	} catch ( char *ErrorText ) {
		// ignore any errors here
	}
	exit(0);
}


static void
StartTimerT2(int seconds) {
	t2 = XtAppAddTimeOut(aContext,300,FF_CB,(XtPointer)seconds);	// Start T2 ticking..
}

static void
FF_CB(XtPointer client_data,XtIntervalId *timer_idp) {
	int seconds = (int)client_data;

	try	{
		cd.play(seconds);
	} catch ( char *ErrorText ) {
		ReportError(ErrorText,__LINE__);
		return;
	}

	if ( t1 == NoTMR )
		StartTimerT1();				// Display currently shows "PAUSED", start T1
	StartTimerT2(seconds);				// Restart for next update
}

static void
CancelTimer(XtIntervalId *pTmr) {
	if ( *pTmr != NoTMR ) {					// Safety first..
		XtRemoveTimeOut(*pTmr);				// Disable timer Tx
		*pTmr = NoTMR;					// Mark it as cancelled
	}
}

/*
 * Get current CD-ROM volume levels, and adjust scroll bars to suit:
 */
static void
ShowVol(int bReportErrors) {
	unsigned l, r;
	Arg al[8];
	Cardinal ac;

	try	{
		l = cd.getLeftVol();				// Read left volume
		r = cd.getRightVol();				// Read right volume

	} catch ( char *ErrorText ) {
		if ( bReportErrors )				// At startup, we ignore errors..
			ReportError(ErrorText,__LINE__);	// else, report with dialog box
		else	fprintf(stderr,"%s\n",ErrorText);	// else always report to stderr
		return;
	}

	/*
	 * Update scroll bars:
	 */
	ac = 0;
	XtSetArg(al[ac],XmNvalue,l); ++ac;
	XtSetValues(wLeftVolSB,al,ac);				// Update left volume scroll bar

	ac = 0;
	XtSetArg(al[ac],XmNvalue,r); ++ac;
	XtSetValues(wRightVolSB,al,ac);				// Update right volume scroll bar
}

/*
 * Volume changed callback: This function is called when the scroll bar
 * gets manipulated by the user.
 */
static void
VolChgCB(Widget w,XtPointer client_data,XtPointer call_data) {
	XmScrollBarCallbackStruct *p = (XmScrollBarCallbackStruct *)call_data;

	try	{						// this may throw if CD ejected etc.
		if ( w == wLeftVolSB )
			cd.setLeftVol(p->value);		// set new left volume setting

		else if ( w == wRightVolSB )
			cd.setRightVol(p->value);		// set new right volume setting

		return;

	} catch ( char *ErrorText ) {
		ReportError(ErrorText,__LINE__);		// Report error
		cd.close();					// CD must have ejected
		return;
	}

	abort();						// We should never get here..
}

/*
 * This function is called in an attempt to open the CD-ROM drive. At application
 * startup, bReportError is false, so that we don't annoy user with error dialogs
 * when the application is started with the tray out for example.
 */
static void
OpenCD(int bReportError) {

	/*
	 * Now open the CDROM drive:
	 */
	try	{
		cd.open(CDROM_PATHNAME);			// Try to open device
		XmTextSetString(wTrackWindow,cd.getPos());	// Update track window if ok above
		if ( cd.isPlaying() )				// Is a CD playing already?
			StartTimerT1();				// Yes, then keep display updated..
		trackNo = cd.getTrack();			// Find out current track #

	} catch ( char *ErrorText ) {
		if ( bReportError )				// we avoid reports upon app. startup..
			ReportError(ErrorText,__LINE__);	// else we report error dialogs
		else	fprintf(stderr,"%s (line %u)\n",ErrorText,__LINE__); // else always to stderr
	}
}

/*
 * This callback is called when the user presses OK in the error
 * dialog. All we do here is to unmanage the error dialog, so that
 * it goes invisible, until its needed again.
 */
static void
ExitDlgCB(Widget w,XtPointer client_data,XtPointer call_data) {
	if ( XtIsManaged(wErrDlg) )					// Safety first..
		XtUnmanageChild(wErrDlg);				// Yes, hide this
}

/*
 * This function initiates the creation of an error dialog with
 * a meaningful error text and an OK button. Note that the dialog
 * box is not operationaly until we return back to the main loop.
 */
static void
ReportError(const char *ErrMsg,unsigned lno) {
	XmString s;							// XmString form of message

	fprintf(stderr,"%s (line %u)\n",ErrMsg,lno);			// Always rpt to stderr
	if ( XtIsManaged(wErrDlg) )
		return;							// The dialog is already in use

	if ( !bReportErrs && !bForceReport )				// Does toggle say ignore??
		return;							// yes, just ignore errors

	/*
	 * Set the Error Dialog message text, and manage it so that it pops up:
	 */
	s = XmStringCreateLtoR((char *)ErrMsg,XmSTRING_DEFAULT_CHARSET);// We need an XmString
	XtVaSetValues(wErrDlg,XmNmessageString,s,NULL);			// Put msg in there
	XtManageChild(wErrDlg);						// Make it pop up
	XmStringFree(s);						// Release the string
}

static void
ForcedErrorReport(const char *ErrMsg,unsigned lno) {
	bForceReport = 1;
	ReportError(ErrMsg,lno);
	bForceReport = 0;
}

static void
ShowProgress() {
	unsigned TrkPercent, CD_Percent;
	struct msf {
		unsigned	min;
		unsigned	sec;
		unsigned	frames;
	} cur_trk, cd;
	static struct msf trk = { 0, 0, 0 };
	char buf[256];

	try	{
		::cd.getProgress(&TrkPercent,&CD_Percent);		// Get progress percentages
		::cd.getTrackMSF(::cd.getTrack(),&cur_trk.min,&cur_trk.sec,&cur_trk.frames);
		::cd.getCDMSF(&cd.min,&cd.sec,&cd.frames);
	} catch ( char *ErrorText ) {
		ReportError(ErrorText,__LINE__);
		return;
	}

	XtVaSetValues(wTrackProgress,XmNvalue,0,XmNsliderSize,TrkPercent + 1,NULL);

	if ( cur_trk.min != trk.min || cur_trk.sec != trk.sec || cur_trk.frames != trk.frames ) {
		trk.min = cur_trk.min;
		trk.sec = cur_trk.sec;
		trk.frames = cur_trk.frames;

		XmStringFree(sTrackProgress);
		sprintf(buf,"Track: %02u:%02u (CD %02u:%02u, %u Audio & %u Data Tracks)",
			(unsigned)trk.min,(unsigned)trk.sec,
			(unsigned)cd.min,(unsigned)cd.sec,
			(unsigned)(::cd.getTracks() - ::cd.getDataTracks()),
			(unsigned)::cd.getDataTracks());
		sTrackProgress = XmStringCreate(buf,XmSTRING_DEFAULT_CHARSET);
		XtVaSetValues(wTrackProgLbl,XmNlabelString,sTrackProgress,NULL);
	}
}

/*
 * This callback is called when the timer T1 expires, so that the Track
 * Display Window can be updated with the CD-ROM status:
 */ 
static void
StateCB(XtPointer client_datap,XtIntervalId *timer_idp) {
	unsigned trk;

	if ( cd.isOpen() ) {						// Is device open?
		try	{						// yes..
			XmTextSetString(wTrackWindow,cd.getPos());	// update display contents..
			ShowProgress();
			ShowVol(1);					// Show volume settings
			trk = cd.getTrack();				// What track are we on ?
			if ( cd.isDataTrack(trk) ) {
				while ( cd.isDataTrack(trk) ) {		// Are we on a data track?
					if ( ++trk > cd.getTracks() )
						return;			// Just stop.. nothing else to do
				}
				cd.play(trk);				// Resume with this audio track
			}
			StartTimerT1();					// restart T1

		} catch ( char *ErrorText ) {
			XmTextSetString(wTrackWindow,"-- --:--");	// on error, show blank look
		}
	}
}

/*
 * This function starts the timer T1 to expire in 500 ms. When
 * T1 expires, StateCB() is called to update the Track Display
 * Window.
 */
static void
StartTimerT1() {
	t1 = XtAppAddTimeOut(aContext,500,StateCB,NULL);		// Start T1 ticking..
}

/*
 * This callback is called when any of the Push Buttons are activated.
 */
static void
PushButtonCB(Widget w,XtPointer client_data,XtPointer call_data) {
	XmAnyCallbackStruct *cbPtr = (XmAnyCallbackStruct *)call_data;
	unsigned ButtonNo = (unsigned)client_data;		// The button # that was pressed
	char buf[32];						// Work buffer
	unsigned x = 0;

	switch ( ButtonNo ) {
	case Button_FF:
	case Button_FB:
		break;						// Don't cancel T1 for these buttons
	default:
		CancelTimer(&t1);				// All other button events, cancel T1
	}

	CancelTimer(&t2);

	/*
	 * For any button press except EJECT when the CD-ROM drive is not open yet,
	 * we try to open it here. EJECT gets special treatment, to help with CD-ROM
	 * drives that go into a "snit" (like mine).
	 */
	if ( ButtonNo != Button_Eject && !cd.isOpen() ) {
		OpenCD(1);					// Report errors here (attempt open)
		if ( !cd.isOpen() ) {				// Did we read TOC ok??
			XmTextSetString(wTrackWindow,"-- --:--"); // Nope, sigh...
			return;					// Can't function yet
		} else	ShowProgress();				// Update progress scroll bars
	}
	
	/*
	 * Control passes here when the CD-ROM drive is open,
	 * or the button is EJECT (open or not):
	 */
	switch ( ButtonNo ) {

	case Button_LeftArrow :					// Backup one track
		if ( trackNo > 1 )
			--trackNo;
		else	trackNo = cd.getTracks();		// Wrap to last track
		ButtonNo = trackNo;
		break;

	case Button_RightArrow :				// Forward one track
		if ( ++trackNo > cd.getTracks() )
			trackNo = 1;				// Wrap to first track
		ButtonNo = trackNo;
		break;

	case Button_Eject:
		/*
		 * Eject can be attempted even when the cd object is not yet open.
		 * This allows the CD to be ejected. Sometimes this helps reset the
		 * device.
		 */
		try	{
			cd.eject();				// EJECT!
		} catch ( char *ErrorText ) {
			ReportError(ErrorText,__LINE__);	// Big time trouble?
		}

		XmTextSetString(wTrackWindow,"-- --:--");	// Display in either case..

		try	{
			cd.close();				// Close for now (no CD in drive)
		} catch ( char *ErrorText ) {
			// Ignore errors here
		}
		return;

	case Button_Stop:					// STOP button
		try	{
			cd.stop();
			XmTextSetString(wTrackWindow,cd.getPos());
		} catch ( char *ErrorText ) {
			ReportError(ErrorText,__LINE__);
		}
		try	{
			trackNo = cd.getTrack();		// Update selection
		} catch ( char *ErrorText ) {
			// Ignore
		}
		return;

	case Button_Play:					// PLAY button
		// Do a quick check to see if all tracks are Data:
		try	{
			for ( x=1; x<=cd.getTracks(); ++x )
				if ( !cd.isDataTrack(x) )
					break;
			if ( x > cd.getTracks() )
				x = 1;				// All data tracks
			else	x = 0;
		} catch ( char *ErrorText ) {
			fprintf(stderr,"%s\n",ErrorText);	// No dialog for this one
		}

		if ( x != 0 ) {
			ForcedErrorReport("There are no audio tracks on this CD.",__LINE__);
			return;
		}

		if ( trackNo < 1 )				// This goes to zero when playing
			trackNo = 1;				// ends, so set back to 1

		if ( cd.isDataTrack(trackNo) ) {
			ReportError("This is a data track.",__LINE__);
			return;
		}

		try	{
			cd.play(trackNo);
			XmTextSetString(wTrackWindow,cd.getPos());
		} catch ( char *ErrorText ) {
			ReportError(ErrorText,__LINE__);
		}

		StartTimerT1();

		try	{
			trackNo = cd.getTrack();		// Update selection
		} catch ( char *ErrorText ) {
			// Ignore
		}
		return;

	case Button_FF:
		if ( cbPtr->reason == XmCR_ARM ) {		// Do fake callback to start immediately:
			FF_CB((XtPointer)(+10),NULL);		// This also starts T2
		} else	{
			// else t2 cancelled upon entry to this CB
			try	{
				trackNo = cd.getTrack();		// Update selection
			} catch ( char *ErrorText ) {
				// Ignore
			}
		}
		return;

	case Button_FB:
		if ( cbPtr->reason == XmCR_ARM ) {		// Do fake callback to start immediately:
			FF_CB((XtPointer)(-5),NULL);		// This also starts T2
		} else	{
			// else t2 cancelled upon entry to this CB
			try	{
				trackNo = cd.getTrack();		// Update selection
			} catch ( char *ErrorText ) {
				// Ignore
			}
		}
		return;

	case Button_Pause:					// PAUSE button
		try	{
			cd.pause();
			XmTextSetString(wTrackWindow,cd.getPos());
		} catch ( char *ErrorText ) {
			ReportError(ErrorText,__LINE__);
		}
		try	{
			trackNo = cd.getTrack();		// Update selection
		} catch ( char *ErrorText ) {
			// Ignore
		}
		return;
	}

	/*
	 * Control passes here if we've selected a new track to play:
	 */
	cd.stop();						// Stop playing for now..
	if ( ButtonNo > cd.getTracks() )
		return;						// TOC says we don't have that track!

	trackNo = ButtonNo;					// New selection made

	sprintf(buf,"%02u <-   ",(unsigned)trackNo);		// Show it
	XmTextSetString(wTrackWindow,buf);
}

/*
 * The infamous "main" program:
 */
int
main(int argc,char **argv) {
	Arg al[20];						// Arg list
	Cardinal ac;						// Args count
	unsigned r, c, ButtonNo;				// row, col, and button #
	char buf1[200];						// Work buffer
	Widget w;						// Current widget
	Pixel botShade, topShade;				// Shade pixels
	XmString xs;
	
	EditVersionInit();					// Edit $Revision: 1.7 $ string into vers[]

	{
		char edited_title[1024];

		EditVersion("X LessTif CD Player Version $",edited_title);

		/*
		 * CreateApplication Context:
		 */
		ac = 0;
		XtSetArg(al[ac],XmNtitle,edited_title); ++ac;
		XtSetArg(al[ac],XmNallowShellResize,FALSE); ++ac; // Not allow resize of window
		wParent = XtAppInitialize(&aContext,
			"XLTCDPlay",				// app. class
			(XrmOptionDescList) NULL, 0,		// options
			&argc, argv,				// cmd line
			fallback_resources,			// fallback resources
			al,ac);					// hard coded resources
	}

	/*
	 * Create Main widget:
	 */
	ac = 0;
	wMain = XmCreateMainWindow(wParent,"main",al,ac);

	ac = 0;
	wMenuBar = XmCreateMenuBar(wMain,"menubar",al,ac);

	CreateMenu(wMenuBar,&wFileMenu,"filemenu",&wFileMenuCascade,"filemenucascade",
		"Error report dialogs",'T',ErrTglChgCB,&wErrTgl,
		"exit",'M',ExitCB,&wExit,
		NULL);

	CreateMenu(wMenuBar,&wHelpMenu,"helpmenu",&wHelpMenuCascade,"helpmenucascade",
		"about",'M',AboutCB,&wAbout,
		NULL);

	/*
	 * Create the error message dialog:
	 */
	sErrDlgTitle = XmStringCreate("X LessTif CD Play : Error Message",XmSTRING_DEFAULT_CHARSET);
	ac = 0;
	XtSetArg(al[ac],XmNdefaultPosition,FALSE); ac++;
	XtSetArg(al[ac],XmNdialogStyle,XmDIALOG_APPLICATION_MODAL); ac++;
	XtSetArg(al[ac],XmNtitle,"Error Report"); ac++;
	XtSetArg(al[ac],XmNdefaultButtonType,XmDIALOG_OK_BUTTON); ++ac;
	XtSetArg(al[ac],XmNmessageAlignment,XmALIGNMENT_CENTER); ++ac;
	XtSetArg(al[ac],XmNdialogTitle,sErrDlgTitle); ++ac;
	XtSetArg(al[ac],XmNallowResize,FALSE); ++ac;
	wErrDlg = XmCreateErrorDialog(wParent,"ErrDlg",al,ac);
	XtAddCallback(wErrDlg,XmNokCallback,ExitDlgCB,NULL);
	XtUnmanageChild(XmMessageBoxGetChild(wErrDlg,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(wErrDlg,XmDIALOG_HELP_BUTTON));

	/*
	 * Create About Dialog:
	 */
	sAboutDlgTitle = XmStringCreate("X LessTif CD Play : Help->About",XmSTRING_DEFAULT_CHARSET);
	{
		char buf[1024];

		EditVersion(
			"X LessTif CD Play Version $\n"
			"was written by and is\n"
			"Copyright (C) 1997 by Warren W. Gay VE3WWG\n"
			"---\n"
			"Many thanks to the LINUX folks,\n"
			"the XFree86 folks,\n"
			"and of course the LessTif group\n"
			"for making this application possible.\n"
			"---\n"
			"This program comes with\n"
			"ABSOLUTELY NO WARRANTY.",
			buf);

		sAboutDlgMessage = XmStringCreateLtoR(buf,XmSTRING_DEFAULT_CHARSET);
	}
		
	ac = 0;
	XtSetArg(al[ac],XmNdefaultPosition,FALSE); ac++;
	XtSetArg(al[ac],XmNtitle,"Error Report"); ac++;
	XtSetArg(al[ac],XmNdefaultButtonType,XmDIALOG_OK_BUTTON); ++ac;
	XtSetArg(al[ac],XmNmessageAlignment,XmALIGNMENT_CENTER); ++ac;
	XtSetArg(al[ac],XmNdialogTitle,sAboutDlgTitle); ++ac;
	XtSetArg(al[ac],XmNallowResize,FALSE); ++ac;
	wAboutDlg = XmCreateMessageDialog(wParent,"AboutDlg",al,ac);
	XtAddCallback(wAboutDlg,XmNokCallback,AboutDlgOkCB,NULL);
	XtUnmanageChild(XmMessageBoxGetChild(wAboutDlg,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(wAboutDlg,XmDIALOG_HELP_BUTTON));

	/*
	 * Create Form:
	 */
	ac = 0;
	wForm = XmCreateForm(wMain,"form",al,ac);

	/*
	 * Create row0 to hold the track selection buttons:
	 */
	ac = 0;
	XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ++ac;
	wRow0 = XmCreateRowColumn(wForm,"row0",al,ac);

	/*
	 * Create Track Selection Buttons:
	 */
	for ( r=0; r<N_BUTROWS; ++r ) {
		for ( c=0; c<N_BUTCOLS; ++c ) {
			ButtonNo = r * N_BUTCOLS + c + 1;
			if ( r == N_BUTROWS - 1 && c >= N_BUTCOLS - 2 ) {
				/*
				 * Button 19 is left arrow, 20 is right arrow:
				 */
				ac = 0;
				if ( c == N_BUTCOLS - 2 ) {
					XtSetArg(al[ac],XmNarrowDirection,XmARROW_LEFT); ++ac;
				} else	{
					XtSetArg(al[ac],XmNarrowDirection,XmARROW_RIGHT); ++ac;
				}
				w = wTracks[r][c] = XmCreateArrowButton(wRow0,
					c == N_BUTCOLS - 2 ? "leftArrow" : "rightArrow",
					al, ac);
			} else	{
				/*
				 * Track Selection Buttons 01 to 18
				 */
				sprintf(buf1,"%02d",ButtonNo);
				ac = 0;
				w = wTracks[r][c] = XmCreatePushButton(wRow0,buf1,al,ac);
			}

			XtAddCallback(w,XmNactivateCallback,PushButtonCB,(XtPointer)ButtonNo);
			XtManageChild(w);
		}
	}

	/*
	 * Volume scroll bars and their labels:
	 */
	ac = 0;
	XtSetArg(al[ac],XmNpacking,XmPACK_COLUMN); ++ac;
	XtSetArg(al[ac],XmNnumColumns,2); ++ac;
	wRowColVol = XmCreateRowColumn(wForm,"volume",al,ac);		// Holds L + R volume controls
	ac = 0;
	XtSetArg(al[ac],XmNorientation,XmVERTICAL); ++ac;
	XtSetArg(al[ac],XmNminimum,0); ++ac;
	XtSetArg(al[ac],XmNsliderSize,32); ++ac;
	XtSetArg(al[ac],XmNmaximum,255+32); ++ac;			// Include slider size
	wLeftVolSB = XmCreateScrollBar(wRowColVol,"left",al,ac);	// Left Vol. Scroll Bar
	wRightVolSB = XmCreateScrollBar(wRowColVol,"right",al,ac);	// Right Vol. Scroll Bar
	XtAddCallback(wLeftVolSB,XmNvalueChangedCallback,VolChgCB,(XtPointer)NULL);
	XtAddCallback(wLeftVolSB,XmNdragCallback,VolChgCB,(XtPointer)NULL);
	XtAddCallback(wRightVolSB,XmNvalueChangedCallback,VolChgCB,(XtPointer)NULL);
	XtAddCallback(wRightVolSB,XmNdragCallback,VolChgCB,(XtPointer)NULL);

	ac = 0;
	XtSetArg(al[ac],XmNentryBorder,0); ++ac;
	XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ++ac;
	XtSetArg(al[ac],XmNspacing,3); ++ac;
	wRow = XmCreateRowColumn(wForm,"row",al,ac);			// For Tracking Window
	wRow2 = XmCreateRowColumn(wForm,"row2",al,ac);			// For push buttons

	/*
	 * Track Display Window:
	 */
	ac = 0;
	XtSetArg(al[ac],XmNeditable,FALSE); ++ac;			// Not editable
	XtSetArg(al[ac],XmNcolumns,8); ++ac;				// 8 cols
	XtSetArg(al[ac],XmNeditMode,XmSINGLE_LINE_EDIT); ++ac;		// 1 line
	XtSetArg(al[ac],XmNcursorPositionVisible,FALSE); ++ac;		// No cursor!
	XtSetArg(al[ac],XmNautoShowCursorPosition,FALSE); ++ac;		// No cursor!
	wTrackWindow = XmCreateText(wRow,"trackWindow",al,ac);		// Display widget
	XmTextSetString(wTrackWindow," -- --:--");			// Initial content

	/*
	 * Eject Button:
	 */
	ac = 0;
	wEject = XmCreatePushButton(wRow2,"Eject",al,ac);
	XtAddCallback(wEject,XmNactivateCallback,PushButtonCB,(XtPointer)Button_Eject);

	/*
	 * Stop Button:
	 */
	ac = 0;
	wStop = XmCreatePushButton(wRow2,"Stop",al,ac);
	XtAddCallback(wStop,XmNactivateCallback,PushButtonCB,(XtPointer)Button_Stop);

	/*
	 * Pause Button:
	 */
	ac = 0;
	wPause = XmCreatePushButton(wRow2,"Pause",al,ac);
	XtAddCallback(wPause,XmNactivateCallback,PushButtonCB,(XtPointer)Button_Pause);

	/*
	 * << Button:
	 */
	ac = 0;
	wFB = XmCreatePushButton(wRow2,"fb",al,ac);
	XtAddCallback(wFB,XmNarmCallback,PushButtonCB,(XtPointer)Button_FB);
	XtAddCallback(wFB,XmNdisarmCallback,PushButtonCB,(XtPointer)Button_FB);

	/*
	 * >> Button:
	 */
	ac = 0;
	wFF = XmCreatePushButton(wRow2,"ff",al,ac);
	XtAddCallback(wFF,XmNarmCallback,PushButtonCB,(XtPointer)Button_FF);
	XtAddCallback(wFF,XmNdisarmCallback,PushButtonCB,(XtPointer)Button_FF);

	/*
	 * Play Button:
	 */
	ac = 0;
	wPlay = XmCreatePushButton(wRow2,"Play",al,ac);
	XtAddCallback(wPlay,XmNactivateCallback,PushButtonCB,(XtPointer)Button_Play);

	/*
	 * Progress Indicator section: Row/Col container:
	 */
	ac = 0;
	XtSetArg(al[ac],XmNorientation,XmVERTICAL); ++ac;
	XtSetArg(al[ac],XmNpacking,XmPACK_COLUMN); ++ac;
	XtSetArg(al[ac],XmNentryAlignment,XmALIGNMENT_CENTER); ++ac;
	wProgRowCol = XmCreateRowColumn(wForm,"progrowcol",al,ac);

	/*
	 * Track Progress labels:
	 */
	sTrackProgress = XmStringCreate("Track",XmSTRING_DEFAULT_CHARSET);

	ac = 0;
	XtSetArg(al[ac],XmNlabelType,XmSTRING); ++ac;
	XtSetArg(al[ac],XmNlabelString,sTrackProgress); ++ac;
	wTrackProgLbl = XmCreateLabel(wProgRowCol,"trkproglbl",al,ac);

	/*
	 * Track Indicators:
	 */
	ac = 0;
	XtSetArg(al[ac],XmNshowArrows,FALSE); ++ac;
	XtSetArg(al[ac],XmNorientation,XmHORIZONTAL); ++ac;
	XtSetArg(al[ac],XmNminimum,0); ++ac;			// 0 %
	XtSetArg(al[ac],XmNmaximum,101); ++ac;			// 100 % + 1 for slider
	XtSetArg(al[ac],XmNprocessingDirection,XmMAX_ON_RIGHT); ++ac;
	XtSetArg(al[ac],XmNsliderSize,1); ++ac;
	XtSetArg(al[ac],XmNvalue,0); ++ac;
	wTrackProgress = XmCreateScrollBar(wProgRowCol,"trkprogind",al,ac);	// For track

	// Link child widgets together in the form:
	// 
	//      ATTACHMENT:					WIDGET
	//      =======================================		===============================
	XtVaSetValues(wRow0,
		XmNtopAttachment,XmATTACH_FORM,	
		XmNleftAttachment,XmATTACH_FORM,	
		NULL);

	XtVaSetValues(wRowColVol,
		XmNleftAttachment,XmATTACH_WIDGET,		XmNleftWidget,wRow0,
		XmNtopAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);

	XtVaSetValues(wRow,
		XmNleftAttachment,XmATTACH_FORM,
		XmNtopAttachment,XmATTACH_WIDGET,		XmNtopWidget,wRow0,
		NULL);

	XtVaSetValues(wRow2,
		XmNleftAttachment,XmATTACH_WIDGET,		XmNleftWidget,wRow,
		XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,	XmNtopWidget,wRow,
		XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET,	XmNrightWidget,wRow0,
		XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,	XmNbottomWidget,wRow,
		NULL);

	XtVaSetValues(wProgRowCol,
		XmNleftAttachment,XmATTACH_FORM,
		XmNtopAttachment,XmATTACH_WIDGET,		XmNtopWidget,wRow,
		XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET,	XmNrightWidget,wRow2,
		NULL);

	/*
	 * Now fix the colours of the TrackingWindow (too work with black background):
	 */
	ac = 0;
	XtSetArg(al[ac],XmNbottomShadowColor,&botShade); ++ac;
	XtSetArg(al[ac],XmNtopShadowColor,&topShade); ++ac;
	XtGetValues(wPlay,al,ac);				// Get from PLAY button
	XtVaSetValues(wTrackWindow,
		XmNtopShadowColor,topShade,
		XmNbottomShadowColor,botShade,
		NULL);

	/*
	 * Manage all remaining widgets now:
	 */
	XtManageChild(wRow0);
	XtManageChild(wRowColVol);
	XtManageChild(wLeftVolSB);				// Left Vol Scroll Bar
	XtManageChild(wRightVolSB);				// Right Vol Scroll Bar
	XtManageChild(wRow);
	XtManageChild(wTrackWindow);				// Track Display Window
	XtManageChild(wFB);
	XtManageChild(wFF);
	XtManageChild(wPlay);					// PLAY button
	XtManageChild(wPause);					// PAUSE button
	XtManageChild(wStop);					// STOP button
	XtManageChild(wEject);					// EJECT button
	XtManageChild(wRow2);
	XtManageChild(wTrackProgress);				// Track Progress Indicator
	XtManageChild(wTrackProgLbl);				// Track Progress Label
	XtManageChild(wProgRowCol);				// Container for Progess indicators
	XtManageChild(wForm);					// Form container widget
	XtManageChild(wMain);					// Main window widget
	XtManageChild(wMenuBar);				// Main window menu bar
	XtManageChild(wFileMenuCascade);			// File Menu cascade button
	XtManageChild(wFileMenu);				// File menu
	XtManageChild(wErrTgl);					// Error Toggle Box
	XtManageChild(wExit);					// File->Exit
	XtManageChild(wHelpMenuCascade);			// Help menu cascade bytton
	XtManageChild(wHelpMenu);				// Help menu
	XtManageChild(wAbout);					// Help->About

	XtRealizeWidget(wParent);				// OK, realize it all..

	/*
	 * Application device initialization: we only attempt to open the drive here,
	 * and don't complain if it fails (the tray may be out etc.)
	 */
	OpenCD(0);						// Don't complain if it fails..

	if ( cd.isOpen() ) {					// Did it open ok?
		StartTimerT1();
		ShowProgress();					// Update progress indicators
	} else	XmTextSetString(wTrackWindow,"-- --:--");	// Otherwise reset display

	/*
	 * The MOTIF Main Loop:
	 */
	XtAppMainLoop(aContext);
	return 0;						// A cookie for the compiler
}                       

// $Source: /wwg/motif/xltcdplay/RCS/xltcdplay.cpp,v $
