/*
     X Workbone CDROM Player

     controlpanel.c

     Copyright (C) 1995 Eric Merth
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h> 
#include <X11/Xaw/Label.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>

void  rewind_(Widget w, XtPointer clientdat, XtPointer caldat);
void  eject(Widget w, XtPointer clientdat, XtPointer caldat);
void  fastforward(Widget w, XtPointer clientdat, XtPointer caldat);
void  skipback(Widget w, XtPointer clientdat, XtPointer caldat);
void  restart(Widget w, XtPointer clientdat, XtPointer caldat);
void  skipforward(Widget w, XtPointer clientdat, XtPointer caldat);
void  stop(Widget w, XtPointer clientdat, XtPointer caldat);
void  pause_(Widget w, XtPointer clientdat, XtPointer caldat);
void  play(Widget w, XtPointer clientdat, XtPointer caldat);
void  quitandplay(Widget w, XtPointer clientdat, XtPointer caldat);
void  quitandstop(Widget w, XtPointer clientdat, XtPointer caldat);
void control_panel(void);
Boolean theWorkProcedure(XtPointer clientdat);
void message(char *);
void  update(Widget w, XtPointer clientdat, XtPointer caldat);
void resetMainWidgetSize(Widget w, XtPointer xtp, XEvent *event, Boolean *cont_dispatch);

extern Widget rootWidget;
extern Widget controlWidget[15];
static Arg control1args[8];

#define NameOfButton(ii) ii - 1 
#define ProcOfButton(ii) ii - 2 

#define MAINWIDTH 322
#define MAINHEIGHT 158
#ifndef ZERO
#define ZERO 0
#endif

/*
 rewind_, play, fastforward, skipback, pause_, skipforward, eject, stop, restart, quitandplay, quitandstop
 */

void control_panel(void) {
   int ii = 0;
   String controlName = "thecontrolpanel";
   char *Names[] = { "XWorkbone", 
                     "Rewind", "Play", "FastForward", 
                     "Previous", "Pause", "Next", 
                     "Eject", "Stop", "Restart", 
                     "QuitAndPlay", "QuitAndStop", 
                     "Status" 
                   };
   XtCallbackProc callback[] = { rewind_, play, fastforward, 
                                 skipback, pause_, skipforward, 
                                 eject, stop, restart, 
                                 quitandplay, quitandstop
                               };
   ii = 0;
   /* Create the container for the controls */
   controlWidget[ii] = XtCreateWidget(controlName, boxWidgetClass, rootWidget, NULL, ZERO); 
   control1args[0].name = XtNwidth;
   control1args[0].value = (XtArgVal) MAINWIDTH;
   control1args[1].name = XtNheight;
   control1args[1].value = (XtArgVal) MAINHEIGHT;
   XtSetValues(controlWidget[ii], control1args, 2);          
   XtManageChild(controlWidget[0]);

   /* Add an event handler to resize to proper size if user resizes the main window. For 100 points, spell resize. */
   XtAddEventHandler(controlWidget[0], StructureNotifyMask, False, resetMainWidgetSize, (XtPointer) NULL);

   /* Put the program name label on the top of container.  */
   ii++; controlWidget[ii] = XtCreateManagedWidget( (String) Names[NameOfButton(ii)], labelWidgetClass, controlWidget[0], NULL, ZERO);

   /* Put in the RW, play, FF, etc buttons. The FF and RW buttons are repeater widgets!  */
   ii++; controlWidget[ii] = XtCreateManagedWidget( (String) Names[NameOfButton(ii)], repeaterWidgetClass, controlWidget[0], NULL, ZERO);
            control1args[0].name = XtNminimumDelay;
            control1args[0].value = (XtArgVal) 100;
            control1args[1].name = XtNinitialDelay;
            control1args[1].value = (XtArgVal) 0;
            control1args[2].name = XtNdecay;
            control1args[2].value = (XtArgVal) 0;
            XtSetValues(controlWidget[ii], control1args, 3);
   ii++; controlWidget[ii] = XtCreateManagedWidget( (String) Names[NameOfButton(ii)], commandWidgetClass, controlWidget[0], NULL, ZERO);
   ii++; controlWidget[ii] = XtCreateManagedWidget( (String) Names[NameOfButton(ii)], repeaterWidgetClass, controlWidget[0], NULL, ZERO);
            XtSetValues(controlWidget[ii], control1args, 3);
   ii++; for (;ii<13;++ii) 
             controlWidget[ii] = XtCreateManagedWidget( (String) Names[NameOfButton(ii)], commandWidgetClass, controlWidget[0], NULL, ZERO);

   /* Put the status label at the bottom of the container.  */
   controlWidget[ii] = XtCreateManagedWidget( (String) Names[NameOfButton(ii)], labelWidgetClass, controlWidget[0], NULL, ZERO);

   /* Attach callback functions to the buttons.  */
   for (ii=2; ii < 13; ++ii) {
      XtAddCallback(controlWidget[ii], (String) "callback", callback[ProcOfButton(ii)] , NULL);
      XtAddCallback(controlWidget[ii], (String) "callback", update, NULL);
   }

   /* Set the shape style and string-name on each label and button.  */
   control1args[0].name = XtNshapeStyle;
   control1args[0].value = (XtArgVal) XawShapeRectangle;
   control1args[1].name = XtNlabel;
   for (ii = 1; ii<14; ++ii) {
      control1args[1].value = (XtArgVal) Names[NameOfButton(ii)];
      XtSetValues(controlWidget[ii], control1args, 2);
   }

   /* Set the dimensions of each leaf widget */
   /* Height */
   control1args[0].name = XtNheight;
   control1args[0].value = (XtArgVal) 20;
   for (ii=1;ii<13;++ii) 
      XtSetValues(controlWidget[ii], control1args, 1);
   /* Width */
   control1args[0].name = XtNwidth;
           control1args[0].value = (XtArgVal) 312; 
   ii = 1; XtSetValues(controlWidget[ii], control1args, 1); /* Program Label */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* RW */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Play */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* FF */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Skip Back */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Pause */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Skip Forward */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Eject */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Stop */
           control1args[0].value = (XtArgVal) 100;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Restart */
           control1args[0].value = (XtArgVal) 153;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* QuitAndPlay */
           control1args[0].value = (XtArgVal) 153;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* QuitAndStop */
           control1args[0].value = (XtArgVal) 312;
   ii++;   XtSetValues(controlWidget[ii], control1args, 1); /* Status Label */
}

