/*
 *  ximp3  A simple mp3 player
 *  
 *  Copyright (C) 2001 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  mats_peterson@swipnet.se  (Mats Peterson)
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include "xingmp3.h"
#include "ximp3.h"
#include "init.h"
#include "info.h"


int open_audio(char *device)
{
    int fd, flags;
    
    if ((fd = open(device, O_WRONLY, 0)) < 0) {
	perror("open");
	return 0;
    }
       
    if ((flags = fcntl(fd, F_GETFL, 0)) < 0) {
	perror("fcntl F_GETFL");
	return 0;
    }

    flags |= O_NONBLOCK;

    if (fcntl(fd, F_SETFL, flags) < 0) {
	perror("fcntl F_SETFL");
	return 0;
    }

    return fd;
}


int config_audio(int bits, int channels, int samprate)
{
    int stereo;
    audio_buf_info info;

    if (ioctl(v->audio_fd, SNDCTL_DSP_SAMPLESIZE, &bits) == -1) {
	errmsg("Couldn't configure sample size");
	return 0;
    }
    stereo = channels - 1;
    if (ioctl(v->audio_fd, SNDCTL_DSP_STEREO, &stereo) == -1) {
	errmsg("Couldn't configure stereo");
	return 0;
    }
    if (ioctl(v->audio_fd, SNDCTL_DSP_SPEED, &samprate) == -1) {
	errmsg("Couldn't configure speed");
	return 0;
    }

    /* Get O/S audio output buffer size */
    if (ioctl(v->audio_fd, SNDCTL_DSP_GETOSPACE, &info) == -1) {
	perror("SNDCTL_DSP_GETOSPACE");
	return -1;
    }
    v->audio_bufsize = info.fragsize * info.fragstotal;
   
    return 1;
}
