/*
 *  ximp3  A simple mp3 player
 *  
 *  Copyright (C) 2001 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  mats_peterson@swipnet.se  (Mats Peterson)
 */

/*
 *  Miscellaneous info display
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include "xingmp3.h"
#include "ximp3.h"


void errmsg(char *s)
{
    if (v->remote) {
	printf("@E %s\n", s);
	sleep(2);
    } else
	fprintf(stderr, "\nERROR: %s\n", s);
}


void out_mpeg_info(MPEG_HEAD * h, int bitrate_arg)
{
    int bitrate, samprate;
    static char *Layer_msg[] = { "INVALID", "III", "II", "I" };
    static char *mode_msg[] = { "STEREO", "JOINT", "DUAL", "MONO" };
    static int sr_table[8] = { 22050L, 24000L, 16000L, 1L,
			       44100L, 48000L, 32000L, 1L
    };

    if (v->remote)
	printf("@S ");
    if (! v->remote)
	printf(" ");
    printf("Layer %s, ", Layer_msg[h->option]);
    printf("%s, ", mode_msg[h->mode]);
    samprate = sr_table[4 * h->id + h->sr_index];
    if ((h->sync & 1) == 0)
	samprate = samprate / 2;  // mpeg25
    printf("%d Hz, ", samprate);
    bitrate = bitrate_arg / 1000;
    printf("%d kbps", bitrate);
    printf("\n");
}


void out_decode_info(MPEG *m, DEC_INFO *decinfo)
{
    printf(" Output Rate     = %6ld\n", decinfo->samprate);
    printf(" Output Channels = %6d\n", decinfo->channels);
    printf(" Output Bits     = %6d\n", decinfo->bits);
    printf(" Output Type     = %6d\n", decinfo->type);
}
