#
#  Miscellaneous routines
#

package provide mpTk 0.6.15

namespace eval mpTk {
    #
    # wmBorderW is the border width of windows without any
    # resize handles (such as transient windows).
    # wmHandleW is the border width of windows *with* resize
    # handles.
    # wmTitleW is the width (height if you wish) of the title
    # bar for windows having one.
    #
    # Adjust these values to match your current window manager
    # configuration for accurate centering of windows.
    #
    variable wmBorderW 2
    variable wmHandleW 2
    variable wmTitleW 20
}


proc mpTk::Misc::centerwin {w} {
    wm withdraw $w
    update idletasks

    if {[wm transient $w] != ""} {
	set hb $::mpTk::wmBorderW
	set vb $hb
    } else {
	set hb $::mpTk::wmHandleW
	set vb [expr {($::mpTk::wmTitleW + $::mpTk::wmHandleW) / 2}]
    }

    set x [expr {[winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 - $hb}]
    set y [expr {[winfo screenheight $w]/2 - [winfo reqheight $w]/2 - $vb}]
    wm geom $w +$x+$y
    wm deiconify $w
}
