// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of Common C++.
// 
// The exception is that, if you link the Common C++ library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "config.h"
#include "macros.h"
#include "thread.h"
#include "digest.h"
#include "stdio.h"

Digest::Digest() :
streambuf(), ostream()
{
	ostream::init((streambuf *)this);
}

ChecksumDigest::ChecksumDigest() :
Digest()
{
	csum = 0;
}

int ChecksumDigest::overflow(int c)
{
	csum += c;
}

unsigned ChecksumDigest::getDigest(unsigned char *buffer)
{
	*buffer = csum;
	return 1;
}

void ChecksumDigest::putDigest(unsigned char *buffer, unsigned len)
{
	while(len--)
		csum += *(buffer++);
}

ostream &ChecksumDigest::strDigest(ostream &os)
{
	char buf[3];

	sprintf(buf, "%02x", csum);
	os << buf;
	return os;
}

CRC16Digest::CRC16Digest() :
Digest()
{
	crc16 = 0;
}

int CRC16Digest::overflow(int c)
{
	crc16 = (unsigned char)(crc16 >> 8) | (crc16 << 8);
	crc16 ^= (unsigned char)(c);
	crc16 ^= (unsigned char)(crc16 & 0xff) >> 4;
	crc16 ^= (crc16 << 8) << 4;
	crc16 ^= ((crc16 & 0xff) << 4) << 1;
}

unsigned CRC16Digest::getDigest(unsigned char *buffer)
{
	memcpy(buffer, &crc16, 2);
	return 2;
}

void CRC16Digest::putDigest(unsigned char *buffer, unsigned len)
{
	while(len--)
		overflow(*buffer++);
}


ostream &CRC16Digest::strDigest(ostream &os)
{
	char buf[5];

	sprintf(buf, "%04x", (unsigned)crc16);
	os << buf;
	return os;
}
	
	
