package Net::Amazon::EMR::ListBootstrapActionsResult;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::Command;


has 'BootstrapActions' => ( is => 'ro',
                            isa => 'Net::Amazon::EMR::Type::ArrayRefofCommand',
                            coerce => 1 );

has 'Marker' => ( is => 'ro',
                  isa => 'Str',
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ListBootstrapActionsResult

=head1 DESCRIPTION

Implements the ListBootstrapActions result type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/API/API_ListBootstrapActions.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
