#ifdef VMS
#include <string.h>
#include <decw$include/Intrinsic.h>
#include <decw$include/Xatom.h>
#else /* UNIX */
#include <strings.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#endif
#include "defs.h"
#include "xws_defs.h"

static enum hor_align	TPHorizontal;
static enum ver_align	TPVertical;
static float		TPCHorizontal, TPCVertical;

/* Text Graphical Primitive routines.  X doesn't provide much support for
 * graphical use of text, so this stuff doesn't do much.  
 * Specifically, I neglect the following text attributes:
 * character height attribute - can't scale X fonts; their size is fixed.
 * character expansion facter - zip.
 * character orientation - X can only do upright.
 * text path - X can only do horizontal; otherwise, place each character. (yuk)
 * font index - choice of font - we have no interface definition.
 */

/* Set text color */

xws_t_colour(r, g, b, index)
float	r, g, b;
int	index;
{
	XSetForeground(Dpy, TextGC, 
		(*xws_get_pixel)(r, g, b, index));
	return(GPLOT_SUCCESS);
}


/* Set text alignment */

xws_t_align(horizontal, vertical, continuous_horizontal, continuous_vertical)
enum hor_align	horizontal;
enum ver_align	vertical;
float		continuous_horizontal, continuous_vertical;
{
	TPHorizontal = horizontal;
	if (horizontal == cont_h)
		TPCHorizontal = continuous_horizontal;
	TPVertical   = vertical;
	if (vertical = cont_v)
		TPCVertical = continuous_vertical;
	return(GPLOT_SUCCESS);
}
/* Draw text, using an X font */

xws_text(x, y, final, string)
int	x, y, final;
char	*string;
{
int	status = GPLOT_SUCCESS;
int	icox, icoy;		/* initial character origin */
int	ter;			/* text extent rectangle width in pixels */
unsigned long property;		/* font property query return variable */


	/* this is correct for text path right when character spacing = 0 */
	ter = XTextWidth(Xfs, string, strlen(string));

	switch (TPHorizontal)
	{
	default:	/* falls through */
	case normal_h:	/* dependent on text path */
		switch (CGMClass5->text_path)
		{
		default:	/* falls through */
		case right:	icox = x;		break;
		case left:	icox = x - ter;		break;
		case up:	/* falls through */
		case down:	icox = x - ter / 2;	break;
		}						break;
	case left_h:	icox = x;				break;	
	case center_h:	icox = x - ter / 2;			break;
	case right_h:	icox = x - ter;				break;
	case cont_h:	icox = x + ter * TPCHorizontal;		break;
	}

	icoy =(MaxY - y);	/* translate to X coordinate system */

	switch (TPVertical)
	{
	default:	/* falls through */
	case normal_v:	/* dependent on text path */
		switch (CGMClass5->text_path)
		{
		default:	/* falls through */
		case right:	/* falls through */
		case left:	/* falls through */
		case up:	break;	/* as is - at baseline */
		case down:	icoy += Xfs->ascent; break;
		}
		break;
	case top_v:	icoy += Xfs->ascent;
			break;
	case cap_v:	if (XGetFontProperty(Xfs, XA_CAP_HEIGHT, &property))
				icoy += property;
			else
				icoy += Xfs->max_bounds.ascent;
			break;
	case half_v:	icoy += ((Xfs->ascent + Xfs->descent - 1) / 2);
			break;
	case base_v:	break;
	case bottom_v:	icoy -= (Xfs->descent - 1);
			break;
	case cont_v:	icoy += ((Xfs->ascent + Xfs->descent - 1)
			* TPCVertical);
			break;
	}

	/* Assume character spacing = 0 */
	switch (CGMClass5->text_path) 
	{
	case left:
	case up:
	case down:
	default:	status = GPLOT_INVALID_PARAMETER;
			/* fall through */
	case right:
		XDrawString(Dpy, Win, TextGC, icox, icoy, string,
		  strlen(string));
	}
	return(status);
}


