/*
 * error.c
 *
 * AUTHORS: Robert Fahy <rfahy@ymail.com>
 * CREDITS: n/a
 * VERSION: 1.01-djgpp
 *
 */

/*
 * TASK:
 * - provides error printing function, similar to GNU's `error_at_line()'
 *
 */

/*
 * TODO:
 * - remedy `vsnprintf()' not available in latest DJGPP (2011)
 *
 */

// standard include files
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

// custom include files
#include "error.h"

// definitions that are used internally
#define FILENAME_SIZE		128
#define FMT_MESSAGE_SIZE	256
#define UNKNOWN_FILENAME	"<Unknown filename>"
#define UNKNOWN_MESSAGE		"<Did not get an error message>"

void print_error(const char *filename, const int linenum, const int errnum, const char *fmt_message, ...)
// ABOUT: prints an error message to Standard Error
// NOTE: if unsure, use the `PRINT_ERROR()' or `PRINT_ERROR_NOERRNO()' macros instead
// TODO: should print executable name too.
//  should pass exit status then exit?
{
	// FIXME: what if this fails?
	char
		filename_[FILENAME_SIZE],
		fmt_message_[FMT_MESSAGE_SIZE];

	int linenum_ = 0;

	// filename sanity check
	if (filename == NULL ||
		*filename == '\0')
		strncpy(filename_, UNKNOWN_FILENAME, sizeof filename_ - 1);
	else
		strncpy(filename_, filename, sizeof filename_ - 1);

	filename_[FILENAME_SIZE - 1] = '\0'; // ensure NIL-termination

	// line number sanity check, default `linenum_' value is 0
	if (linenum >= 0)
		linenum_ = linenum;

	// message sanity check
	if (fmt_message == NULL ||
		*fmt_message == '\0')
		strncpy(fmt_message_, UNKNOWN_MESSAGE, sizeof fmt_message_ - 1);
	else
	{
		va_list args_;

		va_start(args_, fmt_message);
		vsprintf(fmt_message_, fmt_message, args_);
		va_end(args_);
	}

	fmt_message_[FMT_MESSAGE_SIZE - 1] = '\0'; // ensure NIL-termination

	if (errnum) // for errno == 0 we get "Success" ...
		fprintf(stderr, "\n%s @ %d: %s, %s\n", filename_, linenum_, strerror(errnum), fmt_message_);
	else // ... so prevent it from showing
		fprintf(stderr, "\n%s @ %d: %s\n", filename_, linenum_, fmt_message_);
} // ### void print_error(const char *filename, const int linenum, const int errnum, const char *fmt_message, ...)
