/*
 * baseop.h
 *
 * AUTHORS: Robert Fahy <rfahy@ymail.com>
 * CREDITS: n/a
 * VERSION: 1.00
 *
 */

/*
 * TASK:
 * - declare basic operations which are not intrinsic to XOR-FD
 *
 */

/*
 * TODO:
 * - n/a
 *
 */

#ifndef _BASEOP_H_INCLUDED_
#define _BASEOP_H_INCLUDED_

// standard include files
#include <stdio.h>
#include <stdbool.h>

// environment-specific include files
#include <sys/types.h>

// custom include files
#include "error.h"

// these are used to handle cleanup after signals
#define XORFD_ABORT			0
#define XORFD_CONTINUE		1

// ABOUT: automated error checking and printing for `fclose()'
// NOTE: hackish style allows this macro to be used as single instruction in if's, etc.
// CREDITS: idea from Mashall Cline <www.parashift.com>
#define FCLOSE_VERBOSE(file)	\
if (true)\
{\
	if (fclose(file) == EOF)\
		PRINT_ERROR("fclose()");\
}\
else (void)0

// declarations without definitions (aka prototypes)
void signals_setup(void);
void signal_handler(int signal);
void print_usage(const char *program_filename, const char *message);
unsigned char get_percentage(const off_t full, const off_t current);
off_t get_file_size_tame(FILE *file);
off_t get_file_size(FILE *file);

#endif /* _BASEOP_H_INCLUDED_ */
