/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AbstractAttribute;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class VersionRangeAttribute
extends AbstractAttribute {
    public static final String NAME = "version";
    public static final VersionRangeAttribute DEFAULT = new VersionRangeAttribute();
    private final VersionRange range;

    public VersionRangeAttribute() {
        this(Version.emptyVersion.toString());
    }

    public VersionRangeAttribute(String value) {
        this(new VersionRange(value));
    }

    public VersionRangeAttribute(VersionRange range) {
        super(NAME, range.toString());
        this.range = range;
    }

    @Override
    public StringBuilder appendToFilter(StringBuilder builder) {
        return builder.append(this.range.toFilterString(NAME));
    }

    @Override
    public Object getValue() {
        return '\"' + this.range.toString() + '\"';
    }

    public VersionRange getVersionRange() {
        return this.range;
    }
}

