/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.parser.FunctionParser;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.util.CommonFunctionMapUtil;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.BuiltinTypeMap;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FunctionUtil {
    public static final String IMPORT_PRIVATE_FUNCTIONS = "import-private-functions";
    private static final DataverseName FN_DATASET_DATAVERSE_NAME = FunctionSignature.getDataverseName((FunctionIdentifier)BuiltinFunctions.DATASET);
    private static final String FN_DATASET_NAME = BuiltinFunctions.DATASET.getName();

    public static BuiltinFunctionInfo getFunctionInfo(FunctionIdentifier fi) {
        return BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fi);
    }

    public static TypeSignature getTypeDependencyFromFunctionParameter(TypeExpression typeExpr, DataverseName defaultDataverse) {
        switch (typeExpr.getTypeKind()) {
            case ORDEREDLIST: {
                return FunctionUtil.getTypeDependencyFromFunctionParameter(((OrderedListTypeDefinition)typeExpr).getItemTypeExpression(), defaultDataverse);
            }
            case UNORDEREDLIST: {
                return FunctionUtil.getTypeDependencyFromFunctionParameter(((UnorderedListTypeDefinition)typeExpr).getItemTypeExpression(), defaultDataverse);
            }
            case TYPEREFERENCE: {
                TypeReferenceExpression typeRef = (TypeReferenceExpression)typeExpr;
                String typeName = ((Identifier)typeRef.getIdent().getSecond()).toString();
                BuiltinType builtinType = BuiltinTypeMap.getBuiltinType((String)typeName);
                if (builtinType != null) {
                    return null;
                }
                DataverseName typeDataverseName = typeRef.getIdent().getFirst() != null ? (DataverseName)typeRef.getIdent().getFirst() : defaultDataverse;
                return new TypeSignature(typeDataverseName, typeName);
            }
            case RECORD: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalStateException();
    }

    public static FunctionSignature resolveFunctionCall(FunctionSignature fs, SourceLocation sourceLoc, MetadataProvider metadataProvider, Set<FunctionSignature> declaredFunctions, BiFunction<String, Integer, FunctionSignature> builtinFunctionResolver) throws CompilationException {
        FunctionSignature fsBuiltin;
        String name;
        String mappedName;
        boolean isBuiltinFuncDataverse;
        int arity = fs.getArity();
        DataverseName dataverse = fs.getDataverseName();
        if (dataverse == null) {
            dataverse = metadataProvider.getDefaultDataverseName();
        }
        boolean bl = isBuiltinFuncDataverse = dataverse.equals((Object)FunctionConstants.ASTERIX_DV) || dataverse.equals((Object)FunctionConstants.ALGEBRICKS_DV);
        if (!isBuiltinFuncDataverse) {
            FunctionSignature fsWithDv;
            FunctionSignature functionSignature = fsWithDv = fs.getDataverseName() == null ? new FunctionSignature(dataverse, fs.getName(), arity) : fs;
            if (declaredFunctions.contains(fsWithDv)) {
                return fsWithDv;
            }
            try {
                org.apache.asterix.metadata.entities.Function function = metadataProvider.lookupUserDefinedFunction(fsWithDv);
                if (function != null) {
                    return fsWithDv;
                }
            }
            catch (AlgebricksException e) {
                throw new CompilationException(1079, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
            }
            if (fs.getDataverseName() != null) {
                Dataverse dv;
                try {
                    dv = metadataProvider.findDataverse(dataverse);
                }
                catch (AlgebricksException e) {
                    throw new CompilationException(1079, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
                }
                if (dv == null) {
                    throw new CompilationException(1063, sourceLoc, new Serializable[]{dataverse});
                }
            }
        }
        if ((mappedName = CommonFunctionMapUtil.getFunctionMapping(name = fs.getName().toLowerCase())) != null) {
            name = mappedName;
        }
        if ((fsBuiltin = builtinFunctionResolver.apply(name, arity)) == null) {
            throw new CompilationException(1081, sourceLoc, new Serializable[]{fs.toString(false)});
        }
        return fsBuiltin;
    }

    public static BiFunction<String, Integer, FunctionSignature> createBuiltinFunctionResolver(MetadataProvider metadataProvider) {
        boolean includePrivateFunctions = FunctionUtil.getImportPrivateFunctions(metadataProvider);
        return FunctionUtil.createBuiltinFunctionResolver(includePrivateFunctions);
    }

    public static BiFunction<String, Integer, FunctionSignature> createBuiltinFunctionResolver(boolean includePrivateFunctions) {
        return (name, arity) -> {
            String builtinName = name.replace('_', '-');
            BuiltinFunctionInfo finfo = BuiltinFunctions.resolveBuiltinFunction((String)builtinName, (int)arity);
            if (finfo == null) {
                return null;
            }
            if (!includePrivateFunctions && finfo.isPrivate()) {
                return null;
            }
            return new FunctionSignature(finfo.getFunctionIdentifier());
        };
    }

    public static List<FunctionDecl> retrieveUsedStoredFunctions(MetadataProvider metadataProvider, Expression expression, List<FunctionSignature> declaredFunctions, List<FunctionDecl> inputFunctionDecls, IFunctionCollector functionCollector, FunctionParser functionParser, DataverseName defaultDataverse) throws CompilationException {
        List<FunctionDecl> functionDecls;
        List<FunctionDecl> list = functionDecls = inputFunctionDecls == null ? new ArrayList<FunctionDecl>() : new ArrayList<FunctionDecl>(inputFunctionDecls);
        if (expression == null) {
            return functionDecls;
        }
        Set<CallExpr> functionCalls = functionCollector.getFunctionCalls(expression);
        for (CallExpr functionCall : functionCalls) {
            org.apache.asterix.metadata.entities.Function function;
            FunctionSignature fsWithDv;
            FunctionSignature fs = functionCall.getFunctionSignature();
            FunctionSignature functionSignature = fsWithDv = fs.getDataverseName() != null ? fs : new FunctionSignature(defaultDataverse, fs.getName(), fs.getArity());
            if (declaredFunctions != null && declaredFunctions.contains(fsWithDv)) continue;
            try {
                function = metadataProvider.lookupUserDefinedFunction(fsWithDv);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(1079, (Throwable)e, functionCall.getSourceLocation(), new Serializable[]{e.toString()});
            }
            if (function == null || !functionParser.getLanguage().equals(function.getLanguage())) continue;
            FunctionDecl functionDecl = functionParser.getFunctionDecl(function);
            if (functionDecls.contains(functionDecl)) {
                throw new CompilationException(1079, functionCall.getSourceLocation(), new Serializable[]{"Recursive invocation " + ((FunctionDecl)functionDecls.get(functionDecls.size() - 1)).getSignature() + " <==> " + functionDecl.getSignature()});
            }
            functionDecls.add(functionDecl);
            functionDecls = FunctionUtil.retrieveUsedStoredFunctions(metadataProvider, functionDecl.getFuncBody(), declaredFunctions, functionDecls, functionCollector, functionParser, function.getDataverseName());
        }
        return functionDecls;
    }

    public static List<List<Triple<DataverseName, String, String>>> getFunctionDependencies(IQueryRewriter rewriter, Expression expression, MetadataProvider metadataProvider) throws CompilationException {
        Set<CallExpr> functionCalls = rewriter.getFunctionCalls(expression);
        ArrayList<Triple> datasourceDependencies = new ArrayList<Triple>();
        ArrayList<Triple> functionDependencies = new ArrayList<Triple>();
        for (CallExpr functionCall : functionCalls) {
            FunctionSignature signature = functionCall.getFunctionSignature();
            if (FunctionUtil.isBuiltinDatasetFunction(signature)) {
                Pair<DataverseName, String> datasetReference = FunctionUtil.parseDatasetFunctionArguments(functionCall.getExprList(), metadataProvider.getDefaultDataverseName(), functionCall.getSourceLocation(), ExpressionUtils::getStringLiteral);
                datasourceDependencies.add(new Triple(datasetReference.first, datasetReference.second, null));
                continue;
            }
            if (BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)signature.createFunctionIdentifier()) != null) continue;
            functionDependencies.add(new Triple((Object)signature.getDataverseName(), (Object)signature.getName(), (Object)Integer.toString(signature.getArity())));
        }
        ArrayList<List<Triple<DataverseName, String, String>>> dependencies = new ArrayList<List<Triple<DataverseName, String, String>>>(3);
        dependencies.add(datasourceDependencies);
        dependencies.add(functionDependencies);
        dependencies.add(Collections.emptyList());
        return dependencies;
    }

    public static List<List<Triple<DataverseName, String, String>>> getExternalFunctionDependencies(Collection<TypeSignature> dependentTypes) {
        List datasourceDependencies = Collections.emptyList();
        List functionDependencies = Collections.emptyList();
        ArrayList<Triple> typeDependencies = new ArrayList<Triple>(dependentTypes.size());
        for (TypeSignature t : dependentTypes) {
            typeDependencies.add(new Triple((Object)t.getDataverseName(), (Object)t.getName(), null));
        }
        ArrayList<List<Triple<DataverseName, String, String>>> dependencies = new ArrayList<List<Triple<DataverseName, String, String>>>(3);
        dependencies.add(datasourceDependencies);
        dependencies.add(functionDependencies);
        dependencies.add(typeDependencies);
        return dependencies;
    }

    public static boolean isBuiltinDatasetFunction(FunctionSignature fs) {
        return Objects.equals(FN_DATASET_DATAVERSE_NAME, fs.getDataverseName()) && Objects.equals(FN_DATASET_NAME, fs.getName());
    }

    public static Pair<DataverseName, String> parseDatasetFunctionArguments(List<Mutable<ILogicalExpression>> datasetFnArgs, DataverseName defaultDataverseName, SourceLocation sourceLoc) throws CompilationException {
        return FunctionUtil.parseDatasetFunctionArguments(datasetFnArgs, defaultDataverseName, sourceLoc, FunctionUtil::getStringConstant);
    }

    public static <T> Pair<DataverseName, String> parseDatasetFunctionArguments(List<T> datasetFnArgs, DataverseName defaultDataverseName, SourceLocation sourceLoc, Function<T, String> argExtractFunction) throws CompilationException {
        String datasetName;
        DataverseName dataverseName;
        switch (datasetFnArgs.size()) {
            case 1: {
                String datasetArgBackCompat = argExtractFunction.apply(datasetFnArgs.get(0));
                if (datasetArgBackCompat == null) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
                }
                int pos = datasetArgBackCompat.indexOf(46);
                if (pos > 0 && pos < datasetArgBackCompat.length() - 1) {
                    dataverseName = DataverseName.createSinglePartName((String)datasetArgBackCompat.substring(0, pos));
                    datasetName = datasetArgBackCompat.substring(pos + 1);
                    break;
                }
                dataverseName = defaultDataverseName;
                datasetName = datasetArgBackCompat;
                break;
            }
            case 2: {
                String dataverseNameArg = argExtractFunction.apply(datasetFnArgs.get(0));
                if (dataverseNameArg == null) {
                    throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
                }
                dataverseName = DataverseName.createFromCanonicalForm((String)dataverseNameArg);
                datasetName = argExtractFunction.apply(datasetFnArgs.get(1));
                if (datasetName != null) break;
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid argument to dataset()"});
            }
            default: {
                throw new CompilationException(1079, sourceLoc, new Serializable[]{"Invalid number of arguments to dataset()"});
            }
        }
        return new Pair((Object)dataverseName, (Object)datasetName);
    }

    private static String getStringConstant(Mutable<ILogicalExpression> arg) {
        return ConstantExpressionUtil.getStringConstant((ILogicalExpression)((ILogicalExpression)arg.getValue()));
    }

    private static boolean getImportPrivateFunctions(MetadataProvider metadataProvider) {
        String value = (String)metadataProvider.getConfig().get(IMPORT_PRIVATE_FUNCTIONS);
        return value != null && Boolean.parseBoolean(value.toLowerCase());
    }

    public static Set<FunctionSignature> getFunctionSignatures(List<FunctionDecl> declaredFunctions) {
        if (declaredFunctions == null || declaredFunctions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<FunctionSignature> result = new HashSet<FunctionSignature>();
        for (FunctionDecl fd : declaredFunctions) {
            result.add(fd.getSignature());
        }
        return result;
    }

    @FunctionalInterface
    public static interface IFunctionCollector {
        public Set<CallExpr> getFunctionCalls(Expression var1) throws CompilationException;
    }
}

