/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hyracks.api.util.ExperimentProfilerUtils;

public class ExperimentProfiler {
    public static final boolean PROFILE_MODE = false;
    private FileOutputStream fos;
    private String filePath;
    private StringBuilder sb;
    private int printInterval;
    private int addCount;

    public ExperimentProfiler(String filePath, int printInterval) {
        this.filePath = new String(filePath);
        this.sb = new StringBuilder();
        this.printInterval = printInterval;
    }

    public void begin() {
        try {
            this.fos = ExperimentProfilerUtils.openOutputFile(this.filePath);
            this.addCount = 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public synchronized void add(String s) {
        this.sb.append(s);
        if (this.printInterval > 0 && ++this.addCount % this.printInterval == 0) {
            this.flush();
            this.addCount = 0;
        }
    }

    public synchronized void flush() {
        try {
            this.fos.write(this.sb.toString().getBytes());
            this.fos.flush();
            this.sb.setLength(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public synchronized void end() {
        try {
            if (this.fos != null) {
                this.fos.flush();
                this.fos.close();
                this.fos = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }
}

