/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.server.BaseRequest;
import org.apache.hyracks.http.server.utils.HttpUtil;

public class FormUrlEncodedRequest
extends BaseRequest
implements IServletRequest {
    public static IServletRequest create(ChannelHandlerContext ctx, FullHttpRequest request, HttpScheme scheme) {
        Charset charset = HttpUtil.getRequestCharset((HttpRequest)request);
        LinkedHashMap<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
        URLEncodedUtils.parse((String)request.content().toString(charset), (Charset)charset).forEach(pair -> parameters.computeIfAbsent(pair.getName(), a -> new ArrayList()).add(pair.getValue()));
        new QueryStringDecoder(request.uri()).parameters().forEach((name, value) -> parameters.computeIfAbsent((String)name, a -> new ArrayList()).addAll(value));
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
        return new FormUrlEncodedRequest(request, localAddress, remoteAddress, parameters, scheme);
    }

    private FormUrlEncodedRequest(FullHttpRequest request, InetSocketAddress localAddress, InetSocketAddress remoteAddress, Map<String, List<String>> parameters, HttpScheme scheme) {
        super(request, localAddress, remoteAddress, parameters, scheme);
    }
}

