/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.stream.AbstractMultipleInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class AwsS3InputStream
extends AbstractMultipleInputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, String> configuration;
    private final S3Client s3Client;
    private final List<String> filePaths;
    private int nextFileIndex = 0;

    public AwsS3InputStream(Map<String, String> configuration, List<String> filePaths) throws HyracksDataException {
        this.configuration = configuration;
        this.filePaths = filePaths;
        this.s3Client = this.buildAwsS3Client(configuration);
    }

    @Override
    protected boolean advance() throws IOException {
        if (this.filePaths == null || this.filePaths.isEmpty()) {
            return false;
        }
        if (this.nextFileIndex >= this.filePaths.size()) {
            if (this.in != null) {
                CleanupUtils.close((AutoCloseable)this.in, null);
            }
            return false;
        }
        if (this.in != null) {
            CleanupUtils.close((AutoCloseable)this.in, null);
        }
        String bucket = this.configuration.get("container");
        GetObjectRequest.Builder getObjectBuilder = GetObjectRequest.builder();
        GetObjectRequest getObjectRequest = (GetObjectRequest)getObjectBuilder.bucket(bucket).key(this.filePaths.get(this.nextFileIndex)).build();
        try {
            this.in = this.s3Client.getObject(getObjectRequest);
        }
        catch (NoSuchKeyException ex) {
            LOGGER.debug(() -> "Key " + LogRedactionUtil.userData((String)getObjectRequest.key()) + " was not found in bucket " + getObjectRequest.bucket());
            ++this.nextFileIndex;
            return this.advance();
        }
        catch (SdkException ex) {
            throw new RuntimeDataException(1108, new Serializable[]{ex.getMessage()});
        }
        String filename = this.filePaths.get(this.nextFileIndex).toLowerCase();
        if (filename.endsWith(".gz") || filename.endsWith(".gzip")) {
            this.in = new GZIPInputStream((InputStream)this.s3Client.getObject(getObjectRequest), 4096);
        }
        ++this.nextFileIndex;
        if (this.notificationHandler != null) {
            this.notificationHandler.notifyNewSource();
        }
        return true;
    }

    private S3Client buildAwsS3Client(Map<String, String> configuration) throws HyracksDataException {
        try {
            return ExternalDataUtils.AwsS3.buildAwsS3Client(configuration);
        }
        catch (CompilationException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
    }

    @Override
    public boolean stop() {
        return false;
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            CleanupUtils.close((AutoCloseable)this.in, null);
        }
    }

    @Override
    public String getStreamName() {
        return this.getStreamNameAt(this.nextFileIndex - 1);
    }

    @Override
    public String getPreviousStreamName() {
        return this.getStreamNameAt(this.nextFileIndex - 2);
    }

    private String getStreamNameAt(int fileIndex) {
        return fileIndex < 0 || this.filePaths == null || this.filePaths.isEmpty() ? "" : this.filePaths.get(fileIndex);
    }
}

