/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.visitor;

import java.util.ArrayList;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.aql.clause.ForClause;
import org.apache.asterix.lang.aql.expression.FLWOGRExpression;
import org.apache.asterix.lang.aql.visitor.base.AbstractAqlAstVisitor;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;

public class AqlStatementRewriteVisitor
extends AbstractAqlAstVisitor<Void, MetadataProvider> {
    public static final AqlStatementRewriteVisitor INSTANCE = new AqlStatementRewriteVisitor();

    private AqlStatementRewriteVisitor() {
    }

    public Void visit(DeleteStatement deleteStmt, MetadataProvider metadataProvider) {
        ArrayList<LiteralExpr> arguments = new ArrayList<LiteralExpr>();
        DataverseName dataverseName = deleteStmt.getDataverseName();
        if (dataverseName == null) {
            dataverseName = metadataProvider.getDefaultDataverseName();
        }
        String datasetName = deleteStmt.getDatasetName();
        arguments.add(new LiteralExpr((Literal)new StringLiteral(dataverseName.getCanonicalForm())));
        arguments.add(new LiteralExpr((Literal)new StringLiteral(datasetName)));
        CallExpr callExpression = new CallExpr(new FunctionSignature(BuiltinFunctions.DATASET), arguments);
        ArrayList<Clause> clauseList = new ArrayList<Clause>();
        VariableExpr var = deleteStmt.getVariableExpr();
        ForClause forClause = new ForClause(var, (Expression)callExpression);
        clauseList.add((Clause)forClause);
        WhereClause whereClause = null;
        Expression condition = deleteStmt.getCondition();
        if (condition != null) {
            whereClause = new WhereClause(condition);
            clauseList.add((Clause)whereClause);
        }
        VariableExpr returnExpr = new VariableExpr(var.getVar());
        returnExpr.setIsNewVar(false);
        FLWOGRExpression flowgr = new FLWOGRExpression(clauseList, (Expression)returnExpr);
        Query query = new Query(false);
        query.setBody((Expression)flowgr);
        deleteStmt.setQuery(query);
        return null;
    }
}

