/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.runtime.aggregates.utils.PointableHashSet;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractArrayProcessEval;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

@MissingNullInOutFunction
public class ArrayDistinctDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType inputListType;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ArrayDistinctDescriptor();
        }

        public IFunctionTypeInferer createFunctionTypeInferer() {
            return FunctionTypeInferers.SET_ARGUMENT_TYPE;
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_DISTINCT;
    }

    public void setImmutableStates(Object ... states) {
        this.inputListType = (IAType)states[0];
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayDistinctFunction(args, ctx);
            }
        };
    }

    public class ArrayDistinctFunction
    extends AbstractArrayProcessEval {
        private final PointableHashSet itemSet;
        private IPointable item;
        private ArrayBackedValueStorage storage;

        ArrayDistinctFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            super(args, ctx, ArrayDistinctDescriptor.this.inputListType);
            BuiltinType itemType = ArrayDistinctDescriptor.this.inputListType.getTypeTag().isListType() ? ((AbstractCollectionType)ArrayDistinctDescriptor.this.inputListType).getItemType() : BuiltinType.ANY;
            this.itemSet = new PointableHashSet((IObjectPool<List<IPointable>, ATypeTag>)this.arrayListAllocator, (IAType)itemType);
        }

        @Override
        protected void processList(ListAccessor listAccessor, IAsterixListBuilder listBuilder) throws IOException {
            this.itemSet.clear();
            this.item = this.pointableAllocator.allocateEmpty();
            this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
            boolean nullMissingWasAdded = false;
            for (int i = 0; i < listAccessor.size(); ++i) {
                boolean itemInStorage = listAccessor.getOrWriteItem(i, this.item, this.storage);
                if (this.isNullOrMissing(this.item)) {
                    if (nullMissingWasAdded) continue;
                    listBuilder.addItem((IValueReference)this.item);
                    nullMissingWasAdded = true;
                    continue;
                }
                if (!this.itemSet.add(this.item)) continue;
                listBuilder.addItem((IValueReference)this.item);
                this.item = this.pointableAllocator.allocateEmpty();
                if (!itemInStorage) continue;
                this.storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
            }
        }

        private boolean isNullOrMissing(IPointable item) {
            byte tag = item.getByteArray()[item.getStartOffset()];
            return tag == ATypeTag.SERIALIZED_NULL_TYPE_TAG || tag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG;
        }
    }
}

