/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.library.LibraryDescriptor;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.external.library.PythonLibrary;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.network.INetworkSecurityConfig;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.ipc.api.IIPCI;
import org.apache.hyracks.ipc.api.IPayloadSerializerDeserializer;
import org.apache.hyracks.ipc.impl.IPCSystem;
import org.apache.hyracks.ipc.sockets.PlainSocketChannelFactory;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExternalLibraryManager
implements ILibraryManager,
ILifeCycleComponent {
    public static final String LIBRARY_MANAGER_BASE_DIR_NAME = "library";
    private static final String STORAGE_DIR_NAME = "storage";
    private static final String TRASH_DIR_NAME = "trash";
    public static final String REV_0_DIR_NAME = "rev_0";
    public static final String REV_1_DIR_NAME = "rev_1";
    public static final String STAGE_DIR_NAME = "stage";
    public static final String CONTENTS_DIR_NAME = "contents";
    public static final String DESCRIPTOR_FILE_NAME = "lib.json";
    public static final String DISTRIBUTION_DIR = "dist";
    private static final int DOWNLOAD_RETRY_COUNT = 10;
    private static final Logger LOGGER = LogManager.getLogger(ExternalLibraryManager.class);
    private final NodeControllerService ncs;
    private final IPersistedResourceRegistry reg;
    private final ObjectMapper objectMapper;
    private final FileReference baseDir;
    private final FileReference storageDir;
    private final Path storageDirPath;
    private final FileReference trashDir;
    private final FileReference distDir;
    private final Path trashDirPath;
    private final Map<Pair<DataverseName, String>, ILibrary> libraries = new HashMap<Pair<DataverseName, String>, ILibrary>();
    private IPCSystem pythonIPC;
    private final ExternalFunctionResultRouter router;
    private final IIOManager ioManager;
    private boolean sslEnabled;

    public ExternalLibraryManager(NodeControllerService ncs, IPersistedResourceRegistry reg, FileReference appDir, IIOManager ioManager) {
        this.ncs = ncs;
        this.reg = reg;
        this.baseDir = appDir.getChild(LIBRARY_MANAGER_BASE_DIR_NAME);
        this.storageDir = this.baseDir.getChild(STORAGE_DIR_NAME);
        this.storageDirPath = this.storageDir.getFile().toPath();
        this.trashDir = this.baseDir.getChild(TRASH_DIR_NAME);
        this.distDir = this.baseDir.getChild(DISTRIBUTION_DIR);
        this.trashDirPath = this.trashDir.getFile().toPath().normalize();
        this.objectMapper = ExternalLibraryManager.createObjectMapper();
        this.router = new ExternalFunctionResultRouter();
        this.sslEnabled = ncs.getConfiguration().isSslEnabled();
        this.ioManager = ioManager;
    }

    public void initialize(boolean resetStorageData) throws HyracksDataException {
        try {
            this.pythonIPC = new IPCSystem(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), (ISocketChannelFactory)PlainSocketChannelFactory.INSTANCE, (IIPCI)this.router, (IPayloadSerializerDeserializer)new ExternalFunctionResultRouter.NoOpNoSerJustDe());
            this.pythonIPC.start();
            Path baseDirPath = this.baseDir.getFile().toPath();
            if (Files.isDirectory(baseDirPath, new LinkOption[0])) {
                if (resetStorageData) {
                    FileUtils.cleanDirectory((File)this.baseDir.getFile());
                    Files.createDirectory(this.storageDirPath, new FileAttribute[0]);
                    Files.createDirectory(this.trashDirPath, new FileAttribute[0]);
                    IoUtil.flushDirectory((Path)baseDirPath);
                } else {
                    boolean createdDirs = false;
                    if (!Files.isDirectory(this.storageDirPath, new LinkOption[0])) {
                        Files.deleteIfExists(this.storageDirPath);
                        Files.createDirectory(this.storageDirPath, new FileAttribute[0]);
                        createdDirs = true;
                    }
                    if (Files.isDirectory(this.trashDirPath, new LinkOption[0])) {
                        FileUtils.cleanDirectory((File)this.trashDir.getFile());
                    } else {
                        Files.deleteIfExists(this.trashDirPath);
                        Files.createDirectory(this.trashDirPath, new FileAttribute[0]);
                        createdDirs = true;
                    }
                    if (createdDirs) {
                        IoUtil.flushDirectory((Path)baseDirPath);
                    }
                }
            } else {
                FileUtil.forceMkdirs((File)this.baseDir.getFile());
                Files.createDirectory(this.storageDirPath, new FileAttribute[0]);
                Files.createDirectory(this.trashDirPath, new FileAttribute[0]);
                IoUtil.flushDirectory((Path)baseDirPath.getParent().getParent());
                IoUtil.flushDirectory((Path)baseDirPath.getParent());
                IoUtil.flushDirectory((Path)baseDirPath);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean dumpState, OutputStream ouputStream) {
        ExternalLibraryManager externalLibraryManager = this;
        synchronized (externalLibraryManager) {
            for (Map.Entry<Pair<DataverseName, String>, ILibrary> p : this.libraries.entrySet()) {
                ILibrary library = p.getValue();
                try {
                    library.close();
                }
                catch (HyracksDataException e) {
                    LOGGER.warn("Error closing library " + p.getKey().first + "." + (String)p.getKey().second, (Throwable)e);
                }
            }
        }
    }

    public FileReference getStorageDir() {
        return this.storageDir;
    }

    private FileReference getDataverseDir(DataverseName dataverseName) throws HyracksDataException {
        return this.getChildFileRef(this.storageDir, StoragePathUtil.prepareDataverseName((DataverseName)dataverseName));
    }

    public FileReference getLibraryDir(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        FileReference dataverseDir = this.getDataverseDir(dataverseName);
        return this.getChildFileRef(dataverseDir, libraryName);
    }

    public FileReference getDistributionDir() {
        return this.distDir;
    }

    public List<Pair<DataverseName, String>> getLibraryListing() throws IOException {
        final ArrayList<Pair<DataverseName, String>> libs = new ArrayList<Pair<DataverseName, String>>();
        Files.walkFileTree(this.storageDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path currPath, BasicFileAttributes attrs) {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path currPath, BasicFileAttributes attrs) throws HyracksDataException {
                DataverseName candidateDv;
                int currToken;
                if (currPath.equals(ExternalLibraryManager.this.storageDirPath) || currPath.getParent().equals(ExternalLibraryManager.this.storageDirPath)) {
                    return FileVisitResult.CONTINUE;
                }
                if (currPath.getFileName().toString().codePointAt(0) == 94) {
                    return FileVisitResult.CONTINUE;
                }
                String candidateDvAndLib = ExternalLibraryManager.this.storageDirPath.toAbsolutePath().normalize().relativize(currPath.toAbsolutePath().normalize()).toString();
                ArrayList<String> dvParts = new ArrayList<String>();
                String[] tokens = StringUtils.split((String)candidateDvAndLib, (char)File.separatorChar);
                if (tokens == null || tokens.length < 2) {
                    return FileVisitResult.TERMINATE;
                }
                dvParts.add(tokens[0]);
                for (currToken = 1; currToken < tokens.length && tokens[currToken].codePointAt(0) == 94; ++currToken) {
                    dvParts.add(tokens[currToken].substring(1));
                }
                if (currToken != tokens.length - 1) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String candidateLib = tokens[currToken];
                try {
                    candidateDv = DataverseName.create(dvParts);
                }
                catch (AsterixException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                FileReference candidateLibPath = ExternalLibraryManager.this.findLibraryRevDir(candidateDv, candidateLib);
                if (candidateLibPath != null) {
                    libs.add(new Pair((Object)candidateDv, (Object)candidateLib));
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return libs;
    }

    public String getLibraryHash(DataverseName dataverseName, String libraryName) throws IOException {
        FileReference revDir = this.findLibraryRevDir(dataverseName, libraryName);
        if (revDir == null) {
            throw HyracksDataException.create((Throwable)AsterixException.create((ErrorCode)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Library does not exist"}));
        }
        LibraryDescriptor desc = this.getLibraryDescriptor(revDir);
        return desc.getHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILibrary getLibrary(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        Pair<DataverseName, String> key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        ExternalLibraryManager externalLibraryManager = this;
        synchronized (externalLibraryManager) {
            ILibrary library = this.libraries.get(key);
            if (library == null) {
                library = this.loadLibrary(dataverseName, libraryName);
                this.libraries.put(key, library);
            }
            return library;
        }
    }

    private ILibrary loadLibrary(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        FileReference libRevDir = this.findLibraryRevDir(dataverseName, libraryName);
        if (libRevDir == null) {
            throw new HyracksDataException("Cannot find library: " + dataverseName + "." + libraryName);
        }
        FileReference libContentsDir = libRevDir.getChild(CONTENTS_DIR_NAME);
        if (!libContentsDir.getFile().isDirectory()) {
            throw new HyracksDataException("Cannot find library: " + dataverseName + "." + libraryName);
        }
        try {
            ExternalFunctionLanguage libLang = this.getLibraryDescriptor(libRevDir).getLanguage();
            switch (libLang) {
                case JAVA: {
                    return new JavaLibrary(libContentsDir.getFile());
                }
                case PYTHON: {
                    return new PythonLibrary(libContentsDir.getFile());
                }
            }
            throw new HyracksDataException("Invalid language: " + libraryName);
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialize library " + dataverseName + "." + libraryName, (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public byte[] serializeLibraryDescriptor(LibraryDescriptor libraryDescriptor) throws HyracksDataException {
        try {
            return this.objectMapper.writeValueAsBytes((Object)libraryDescriptor.toJson(this.reg));
        }
        catch (JsonProcessingException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private LibraryDescriptor deserializeLibraryDescriptor(byte[] data) throws IOException {
        JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(data, JsonNode.class);
        return (LibraryDescriptor)this.reg.deserialize(jsonNode);
    }

    private LibraryDescriptor getLibraryDescriptor(FileReference revDir) throws IOException {
        FileReference descFile = revDir.getChild(DESCRIPTOR_FILE_NAME);
        byte[] descData = Files.readAllBytes(descFile.getFile().toPath());
        return this.deserializeLibraryDescriptor(descData);
    }

    private FileReference findLibraryRevDir(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        FileReference libraryBaseDir = this.getLibraryDir(dataverseName, libraryName);
        if (!libraryBaseDir.getFile().isDirectory()) {
            return null;
        }
        FileReference libDirRev1 = libraryBaseDir.getChild(REV_1_DIR_NAME);
        if (libDirRev1.getFile().isDirectory()) {
            return libDirRev1;
        }
        FileReference libDirRev0 = libraryBaseDir.getChild(REV_0_DIR_NAME);
        if (libDirRev0.getFile().isDirectory()) {
            return libDirRev0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLibrary(DataverseName dataverseName, String libraryName) throws HyracksDataException {
        ILibrary library;
        Pair<DataverseName, String> key = ExternalLibraryManager.getKey(dataverseName, libraryName);
        ExternalLibraryManager externalLibraryManager = this;
        synchronized (externalLibraryManager) {
            library = this.libraries.remove(key);
        }
        if (library != null) {
            library.close();
        }
    }

    public void dumpState(OutputStream os) {
    }

    private static Pair<DataverseName, String> getKey(DataverseName dataverseName, String libraryName) {
        return new Pair((Object)dataverseName, (Object)libraryName);
    }

    public Path zipAllLibs() throws IOException {
        final byte[] copyBuf = new byte[4096];
        Path outDir = Paths.get(this.baseDir.getAbsolutePath(), DISTRIBUTION_DIR);
        FileUtil.forceMkdirs((File)outDir.toFile());
        Path outZip = Files.createTempFile(outDir, "all_", ".zip", new FileAttribute[0]);
        try (FileOutputStream out = new FileOutputStream(outZip.toFile());
             final ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)out);){
            Files.walkFileTree(this.storageDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path currPath, BasicFileAttributes attrs) throws IOException {
                    ZipArchiveEntry e = new ZipArchiveEntry(currPath.toFile(), ExternalLibraryManager.this.storageDirPath.relativize(currPath).toString());
                    zipOut.putArchiveEntry((ArchiveEntry)e);
                    try (FileInputStream fileRead = new FileInputStream(currPath.toFile());){
                        IOUtils.copyLarge((InputStream)fileRead, (OutputStream)zipOut, (byte[])copyBuf);
                        zipOut.closeArchiveEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path currPath, BasicFileAttributes attrs) throws IOException {
                    if (currPath.equals(ExternalLibraryManager.this.storageDirPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    ZipArchiveEntry e = new ZipArchiveEntry(currPath.toFile(), ExternalLibraryManager.this.storageDirPath.relativize(currPath).toString());
                    zipOut.putArchiveEntry((ArchiveEntry)e);
                    return FileVisitResult.CONTINUE;
                }
            });
            zipOut.finish();
        }
        return outZip;
    }

    public void dropLibraryPath(FileReference fileRef) throws HyracksDataException {
        try {
            Path path = fileRef.getFile().toPath();
            Path trashPath = Files.createTempDirectory(this.trashDirPath, null, new FileAttribute[0]);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Drop (move) {} into {}", (Object)path, (Object)trashPath);
            }
            Files.move(path, trashPath, StandardCopyOption.ATOMIC_MOVE);
            this.ncs.getWorkQueue().schedule((AbstractWork)new DeleteDirectoryWork(trashPath));
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private FileReference getChildFileRef(FileReference dir, String fileName) throws HyracksDataException {
        Path dirPath = dir.getFile().toPath().toAbsolutePath().normalize();
        FileReference fileRef = dir.getChild(fileName);
        Path filePath = fileRef.getFile().toPath().toAbsolutePath().normalize();
        if (!filePath.startsWith(dirPath)) {
            throw new HyracksDataException("Invalid file name: " + fileName);
        }
        return fileRef;
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        om.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        om.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return om;
    }

    public ExternalFunctionResultRouter getRouter() {
        return this.router;
    }

    public IPCSystem getIPCI() {
        return this.pythonIPC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDigest download(FileReference targetFile, String authToken, URI libLocation) throws HyracksException {
        try {
            targetFile.getFile().createNewFile();
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        IFileHandle fHandle = this.ioManager.open(targetFile, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        MessageDigest digest = DigestUtils.getDigest((String)"MD5");
        try {
            CloseableHttpClient httpClient = this.newClient();
            try {
                HttpGet request = new HttpGet(libLocation);
                request.setHeader("Authorization", authToken);
                int tried = 0;
                IOException trace = null;
                while (tried < 10) {
                    ++tried;
                    CloseableHttpResponse response = null;
                    try {
                        response = httpClient.execute((HttpUriRequest)request);
                        if (response.getStatusLine().getStatusCode() != 200) {
                            throw new IOException("Http Error: " + response.getStatusLine().getStatusCode());
                        }
                        HttpEntity e = response.getEntity();
                        if (e == null) {
                            throw new IOException("No response");
                        }
                        WritableByteChannel outChannel = this.ioManager.newWritableChannel(fHandle);
                        DigestOutputStream outStream = new DigestOutputStream(Channels.newOutputStream(outChannel), digest);
                        e.writeTo((OutputStream)outStream);
                        ((OutputStream)outStream).flush();
                        this.ioManager.sync(fHandle, true);
                        MessageDigest messageDigest = digest;
                        return messageDigest;
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to download library", (Throwable)e);
                        trace = e;
                        try {
                            this.ioManager.truncate(fHandle, 0L);
                            digest.reset();
                        }
                        catch (IOException e2) {
                            throw HyracksDataException.create((Throwable)e2);
                        }
                    }
                    finally {
                        if (response == null) continue;
                        try {
                            response.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("Failed to close", (Throwable)e);
                        }
                    }
                }
                throw HyracksDataException.create(trace);
            }
            finally {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close", (Throwable)e);
                }
            }
        }
        finally {
            try {
                this.ioManager.close(fHandle);
            }
            catch (HyracksDataException e) {
                LOGGER.warn("Failed to close", (Throwable)e);
            }
        }
    }

    public void unzip(FileReference sourceFile, FileReference outputDir) throws IOException {
        boolean logTraceEnabled = LOGGER.isTraceEnabled();
        HashSet<Path> newDirs = new HashSet<Path>();
        Path outputDirPath = outputDir.getFile().toPath().toAbsolutePath().normalize();
        try (ZipFile zipFile = new ZipFile(sourceFile.getFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] writeBuf = new byte[4096];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                Path entryOutputPath = outputDirPath.resolve(entry.getName()).toAbsolutePath().normalize();
                if (!entryOutputPath.startsWith(outputDirPath)) {
                    throw new IOException("Malformed ZIP archive: " + entry.getName());
                }
                Path entryOutputDir = entryOutputPath.getParent();
                Files.createDirectories(entryOutputDir, new FileAttribute[0]);
                Path p = entryOutputDir;
                while (!p.equals(outputDirPath)) {
                    newDirs.add(p);
                    p = p.getParent();
                }
                InputStream in = zipFile.getInputStream(entry);
                try {
                    FileReference entryOutputFileRef = this.ioManager.resolveAbsolutePath(entryOutputPath.toString());
                    if (logTraceEnabled) {
                        LOGGER.trace("Extracting file {}", (Object)entryOutputFileRef);
                    }
                    this.writeAndForce(entryOutputFileRef, in, writeBuf);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        for (Path newDir : newDirs) {
            IoUtil.flushDirectory((Path)newDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndForce(FileReference outputFile, InputStream dataStream, byte[] copyBuffer) throws IOException {
        outputFile.getFile().createNewFile();
        IFileHandle fHandle = this.ioManager.open(outputFile, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        WritableByteChannel outChannel = this.ioManager.newWritableChannel(fHandle);
        try (OutputStream outputStream = Channels.newOutputStream(outChannel);){
            IOUtils.copyLarge((InputStream)dataStream, (OutputStream)outputStream, (byte[])copyBuffer);
            outputStream.flush();
            this.ioManager.sync(fHandle, true);
        }
        finally {
            this.ioManager.close(fHandle);
        }
    }

    private CloseableHttpClient newClient() {
        if (this.sslEnabled) {
            try {
                INetworkSecurityManager networkSecurityManager = this.ncs.getNetworkSecurityManager();
                INetworkSecurityConfig configuration = networkSecurityManager.getConfiguration();
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                try (FileInputStream trustStoreFile = new FileInputStream(configuration.getTrustStoreFile());){
                    trustStore.load(trustStoreFile, configuration.getKeyStorePassword().toCharArray());
                }
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
                return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return HttpClients.createDefault();
    }

    private static final class DeleteDirectoryWork
    extends AbstractWork {
        private final Path path;

        private DeleteDirectoryWork(Path path) {
            this.path = path;
        }

        public void run() {
            try {
                IoUtil.delete((Path)this.path);
            }
            catch (HyracksDataException e) {
                LOGGER.warn("Error deleting " + this.path);
            }
        }
    }
}

