/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.expression.TypeExpression;

public class InternalDetailsDecl implements IDatasetDetailsDecl {
    private final List<List<String>> partitioningExprs;
    private final List<Integer> keySourceIndicators;
    private final Integer filterSourceIndicator;
    private final boolean autogenerated;
    private final List<String> filterField;
    private final List<TypeExpression> partitioningExprTypes;

    public InternalDetailsDecl(List<List<String>> partitioningExpr, List<Integer> keySourceIndicators,
            boolean autogenerated, Integer filterSourceIndicator, List<String> filterField,
            List<TypeExpression> partitioningExprTypes) throws CompilationException {
        this.partitioningExprs = partitioningExpr;
        this.keySourceIndicators = keySourceIndicators;
        this.autogenerated = autogenerated;
        if (filterSourceIndicator == null && filterField != null
                || filterSourceIndicator != null && filterField == null) {
            throw new CompilationException(ErrorCode.INCONSISTENT_FILTER_INDICATOR);
        }
        this.filterField = filterField;
        this.filterSourceIndicator = filterSourceIndicator;
        this.partitioningExprTypes = partitioningExprTypes;
    }

    public InternalDetailsDecl(List<List<String>> partitioningExpr, List<Integer> keySourceIndicators,
            boolean autogenerated, Integer filterSourceIndicator, List<String> filterField)
            throws CompilationException {
        this(partitioningExpr, keySourceIndicators, autogenerated, filterSourceIndicator, filterField, null);
    }

    public List<List<String>> getPartitioningExprs() {
        return partitioningExprs;
    }

    public List<TypeExpression> getPartitioningExprTypes() {
        return partitioningExprTypes;
    }

    public List<Integer> getKeySourceIndicators() {
        return keySourceIndicators;
    }

    public boolean isAutogenerated() {
        return autogenerated;
    }

    public List<String> getFilterField() {
        return filterField;
    }

    public Integer getFilterSourceIndicator() {
        return filterSourceIndicator;
    }
}
