/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.Arrays;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.impl.AbstractRecordFunctionTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;

public class RecordRemoveTypeComputer
extends AbstractRecordFunctionTypeComputer {
    public static final RecordRemoveTypeComputer INSTANCE = new RecordRemoveTypeComputer();

    private RecordRemoveTypeComputer() {
    }

    @Override
    public IAType computeTypeImpl(AbstractFunctionCallExpression functionCallExpression, IVariableTypeEnvironment env, ARecordType inputRecordType, boolean isOutputMissable, boolean isOutputNullable) {
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return RecordRemoveTypeComputer.wrapTypeWithUnknown(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, isOutputMissable, isOutputNullable);
        }
        ConstantExpression constantExpression = (ConstantExpression)arg1;
        AsterixConstantValue constantValue = (AsterixConstantValue)constantExpression.getValue();
        String fieldName = ((AString)constantValue.getObject()).getStringValue();
        ARecordType outputRecordType = inputRecordType;
        if (Arrays.asList(inputRecordType.getFieldNames()).contains(fieldName)) {
            String[] fieldNames = new String[inputRecordType.getFieldNames().length - 1];
            IAType[] fieldTypes = new IAType[inputRecordType.getFieldTypes().length - 1];
            int currentOutputCursor = 0;
            for (int i = 0; i < inputRecordType.getFieldNames().length; ++i) {
                String inputName = inputRecordType.getFieldNames()[i];
                IAType inputType = inputRecordType.getFieldTypes()[i];
                if (inputName.equals(fieldName)) continue;
                fieldNames[currentOutputCursor] = inputName;
                fieldTypes[currentOutputCursor] = inputType;
                ++currentOutputCursor;
            }
            String inputTypeName = inputRecordType.getTypeName();
            String outputTypeName = inputTypeName != null ? inputTypeName + "_remove_" + fieldName : null;
            outputRecordType = new ARecordType(outputTypeName, fieldNames, fieldTypes, inputRecordType.isOpen());
        }
        return RecordRemoveTypeComputer.wrapTypeWithUnknown(outputRecordType, isOutputMissable, isOutputNullable);
    }
}

