/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.util.CommonFunctionMapUtil;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class FunctionMapUtil {
    public static final String CONCAT = "concat";
    public static final String DISTINCT_AGGREGATE_SUFFIX = "-distinct";
    private static final String CORE_AGGREGATE_PREFIX = "strict_";
    private static final String ALT_CORE_AGGREGATE_PREFIX = "coll_";
    private static final String CORE_SQL_AGGREGATE_PREFIX = "array_";
    private static final String INTERNAL_SQL_AGGREGATE_PREFIX = "sql-";
    private static final Set<String> CORE_AGGREGATE_PREFIX_FUNCTIONS = new HashSet<String>();
    private static final Map<String, String> LIST_INPUT_FUNCTION_MAP = new HashMap<String, String>();

    public static boolean isSql92AggregateFunction(FunctionSignature signature) {
        String name = FunctionMapUtil.applySql92AggregateNameMapping(signature.getName().toLowerCase());
        BuiltinFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)FunctionConstants.newAsterix((String)name, (int)signature.getArity()));
        if (finfo == null) {
            return false;
        }
        return BuiltinFunctions.getAggregateFunction((FunctionIdentifier)finfo.getFunctionIdentifier()) != null;
    }

    public static FunctionSignature sql92ToCoreAggregateFunction(FunctionSignature fs) {
        if (!FunctionMapUtil.isSql92AggregateFunction(fs)) {
            return fs;
        }
        String name = FunctionMapUtil.applySql92AggregateNameMapping(fs.getName().toLowerCase());
        String prefix = CORE_AGGREGATE_PREFIX_FUNCTIONS.contains(name) ? CORE_AGGREGATE_PREFIX : CORE_SQL_AGGREGATE_PREFIX;
        return FunctionSignature.newAsterix((String)(prefix + name), (int)fs.getArity());
    }

    public static boolean isCoreAggregateFunction(FunctionSignature fs) {
        return FunctionMapUtil.findInternalCoreAggregateFunction(fs) != null;
    }

    public static FunctionIdentifier findInternalCoreAggregateFunction(FunctionSignature fs) {
        String internalName = FunctionMapUtil.getInternalCoreAggregateFunctionName(fs);
        if (internalName == null) {
            return null;
        }
        FunctionIdentifier fi = FunctionConstants.newAsterix((String)internalName, (int)fs.getArity());
        BuiltinFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)fi);
        if (finfo == null) {
            return null;
        }
        FunctionIdentifier fid = finfo.getFunctionIdentifier();
        return BuiltinFunctions.getAggregateFunction((FunctionIdentifier)fid) != null ? fid : null;
    }

    public static void normalizedListInputFunctions(CallExpr callExpr) {
        FunctionSignature fs = callExpr.getFunctionSignature();
        String internalFuncName = LIST_INPUT_FUNCTION_MAP.get(fs.getName().toLowerCase());
        if (internalFuncName == null) {
            return;
        }
        callExpr.setFunctionSignature(FunctionSignature.newAsterix((String)internalFuncName, (int)1));
        ListConstructor listConstr = new ListConstructor(ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR, callExpr.getExprList());
        listConstr.setSourceLocation(callExpr.getSourceLocation());
        callExpr.setExprList(new ArrayList<ListConstructor>(Collections.singletonList(listConstr)));
    }

    private static String getInternalCoreAggregateFunctionName(FunctionSignature fs) {
        String name = fs.getName().toLowerCase();
        if (name.startsWith(CORE_AGGREGATE_PREFIX)) {
            return name.substring(CORE_AGGREGATE_PREFIX.length());
        }
        if (name.startsWith(ALT_CORE_AGGREGATE_PREFIX)) {
            return name.substring(ALT_CORE_AGGREGATE_PREFIX.length());
        }
        if (name.startsWith(CORE_SQL_AGGREGATE_PREFIX)) {
            return INTERNAL_SQL_AGGREGATE_PREFIX + name.substring(CORE_SQL_AGGREGATE_PREFIX.length());
        }
        return null;
    }

    public static FunctionIdentifier getInternalWindowFunction(FunctionSignature signature) {
        BuiltinFunctionInfo finfo = FunctionUtil.getFunctionInfo((FunctionIdentifier)FunctionConstants.newAsterix((String)signature.getName().toLowerCase(), (int)signature.getArity()));
        return finfo != null ? BuiltinFunctions.getWindowFunction((FunctionIdentifier)finfo.getFunctionIdentifier()) : null;
    }

    private static String applySql92AggregateNameMapping(String functionName) {
        boolean distinct = functionName.endsWith(DISTINCT_AGGREGATE_SUFFIX);
        if (distinct) {
            String mainName = CommonFunctionMapUtil.getFunctionMapping((String)functionName.substring(0, functionName.length() - DISTINCT_AGGREGATE_SUFFIX.length()));
            if (mainName != null) {
                return mainName + DISTINCT_AGGREGATE_SUFFIX;
            }
        } else {
            String mainName = CommonFunctionMapUtil.getFunctionMapping((String)functionName);
            if (mainName != null) {
                return mainName;
            }
        }
        return functionName;
    }

    public static FunctionIdentifier createCoreAggregateFunctionIdentifier(FunctionIdentifier scalarfi) {
        return BuiltinFunctions.getAggregateFunction((FunctionIdentifier)scalarfi) != null ? new FunctionIdentifier(scalarfi.getDatabase(), scalarfi.getNamespace(), CORE_AGGREGATE_PREFIX + scalarfi.getName(), scalarfi.getArity()) : null;
    }

    static {
        CORE_AGGREGATE_PREFIX_FUNCTIONS.add(BuiltinFunctions.SCALAR_ARRAYAGG.getName());
        CORE_AGGREGATE_PREFIX_FUNCTIONS.add(BuiltinFunctions.SCALAR_ARRAYAGG_DISTINCT.getName());
        LIST_INPUT_FUNCTION_MAP.put(CONCAT, BuiltinFunctions.STRING_CONCAT.getName());
        LIST_INPUT_FUNCTION_MAP.put("greatest", "array_max");
        LIST_INPUT_FUNCTION_MAP.put("least", "array_min");
    }
}

