/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.records.AbstractRecordFunctionEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordRemoveEvaluator
extends AbstractRecordFunctionEvaluator {
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IPointable fieldToRemovePointable = new VoidPointable();

    RecordRemoveEvaluator(IScalarEvaluator eval0, IScalarEvaluator eval1, ARecordType outRecType, ARecordType inRecType) {
        super(outRecType, inRecType);
        this.eval0 = eval0;
        this.eval1 = eval1;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputPointable);
        this.eval1.evaluate(tuple, this.fieldToRemovePointable);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputPointable, this.fieldToRemovePointable)) {
            return;
        }
        byte[] data = this.inputPointable.getByteArray();
        byte typeTag = data[offset = this.inputPointable.getStartOffset()];
        if (typeTag != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
            PointableHelper.setNull(result);
            return;
        }
        data = this.fieldToRemovePointable.getByteArray();
        typeTag = data[offset = this.fieldToRemovePointable.getStartOffset()];
        if (typeTag != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(result);
            return;
        }
        try {
            this.outRecordBuilder.reset(this.outRecType);
            this.outputRecordTypeInfo.reset(this.outRecType);
            if (this.inputRecordPointable == null) {
                this.inputRecordPointable = this.pointableAllocator.allocateRecordValue((IAType)this.inRecType);
            }
            this.inputRecordPointable.set((IValueReference)this.inputPointable);
            List fieldNames = this.inputRecordPointable.getFieldNames();
            List fieldValues = this.inputRecordPointable.getFieldValues();
            int fieldCount = fieldNames.size();
            for (int i = 0; i < fieldCount; ++i) {
                IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(i);
                IVisitablePointable fieldValue = (IVisitablePointable)fieldValues.get(i);
                if (PointableHelper.isEqual((IValueReference)fieldName, (IValueReference)this.fieldToRemovePointable, this.stringBinaryComparator)) continue;
                int pos = this.outputRecordTypeInfo.getFieldIndex(fieldName.getByteArray(), fieldName.getStartOffset() + 1, fieldName.getLength() - 1);
                if (pos >= 0) {
                    this.outRecordBuilder.addField(pos, (IValueReference)fieldValue);
                    continue;
                }
                this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValue);
            }
            this.outRecordBuilder.write(this.resultOutput, true);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

