/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.assembler.value;

import org.apache.asterix.column.assembler.value.BooleanValueGetter;
import org.apache.asterix.column.assembler.value.DoubleValueGetter;
import org.apache.asterix.column.assembler.value.FloatValueGetter;
import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.assembler.value.IValueGetterFactory;
import org.apache.asterix.column.assembler.value.Int16ValueGetter;
import org.apache.asterix.column.assembler.value.Int32ValueGetter;
import org.apache.asterix.column.assembler.value.Int64ValueGetter;
import org.apache.asterix.column.assembler.value.Int8ValueGetter;
import org.apache.asterix.column.assembler.value.MissingValueGetter;
import org.apache.asterix.column.assembler.value.NullValueGetter;
import org.apache.asterix.column.assembler.value.StringValueGetter;
import org.apache.asterix.column.assembler.value.UUIDValueGetter;
import org.apache.asterix.om.types.ATypeTag;

public class ValueGetterFactory
implements IValueGetterFactory {
    public static final IValueGetterFactory INSTANCE = new ValueGetterFactory();

    private ValueGetterFactory() {
    }

    @Override
    public IValueGetter createValueGetter(ATypeTag typeTag) {
        switch (typeTag) {
            case NULL: {
                return NullValueGetter.INSTANCE;
            }
            case MISSING: {
                return MissingValueGetter.INSTANCE;
            }
            case BOOLEAN: {
                return new BooleanValueGetter();
            }
            case TINYINT: {
                return new Int8ValueGetter();
            }
            case SMALLINT: {
                return new Int16ValueGetter();
            }
            case INTEGER: {
                return new Int32ValueGetter();
            }
            case BIGINT: {
                return new Int64ValueGetter();
            }
            case FLOAT: {
                return new FloatValueGetter();
            }
            case DOUBLE: {
                return new DoubleValueGetter();
            }
            case STRING: {
                return new StringValueGetter();
            }
            case UUID: {
                return new UUIDValueGetter();
            }
        }
        throw new UnsupportedOperationException(typeTag + " is not supported");
    }
}

