/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.encoder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.column.bytes.encoder.AbstractParquetValuesWriter;
import org.apache.asterix.column.bytes.encoder.ParquetDeltaBinaryPackingValuesWriterForInteger;
import org.apache.asterix.column.bytes.stream.out.MultiTemporaryBufferBytesOutputStream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.LittleEndianDataOutputStream;
import org.apache.parquet.io.ParquetEncodingException;

public class ParquetDeltaLengthByteArrayValuesWriter
extends AbstractParquetValuesWriter {
    private final ParquetDeltaBinaryPackingValuesWriterForInteger lengthWriter;
    private final MultiTemporaryBufferBytesOutputStream outputStream;
    private final LittleEndianDataOutputStream out;

    public ParquetDeltaLengthByteArrayValuesWriter(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.outputStream = new MultiTemporaryBufferBytesOutputStream(multiPageOpRef);
        this.out = new LittleEndianDataOutputStream((OutputStream)this.outputStream);
        this.lengthWriter = new ParquetDeltaBinaryPackingValuesWriterForInteger(multiPageOpRef);
    }

    @Override
    public void writeBytes(IValueReference value, boolean skipLengthBytes) {
        try {
            this.lengthWriter.writeInteger(value.getLength());
            this.out.write(value.getByteArray(), value.getStartOffset(), value.getLength());
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", (Throwable)e);
        }
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", (Throwable)e);
        }
        BytesInput lengthBytes = this.lengthWriter.getBytes();
        BytesInput lengthSize = BytesInput.fromUnsignedVarInt((int)((int)lengthBytes.size()));
        BytesInput arrayBytes = this.outputStream.asBytesInput();
        return BytesInput.concat((BytesInput[])new BytesInput[]{lengthSize, lengthBytes, arrayBytes});
    }

    @Override
    public void reset() throws HyracksDataException {
        this.lengthWriter.reset();
        this.outputStream.reset();
    }

    @Override
    public void close() {
        this.lengthWriter.close();
        this.outputStream.finish();
    }

    @Override
    public int getEstimatedSize() {
        return this.lengthWriter.getEstimatedSize() + this.outputStream.size();
    }

    @Override
    public int getAllocatedSize() {
        return this.lengthWriter.getAllocatedSize() + this.outputStream.capacity();
    }
}

