/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.in;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;

public final class ByteBufferInputStream
extends AbstractBytesInputStream {
    private ByteBuffer buffer;
    private int mark = -1;

    @Override
    public void reset(IColumnBufferProvider bufferProvider) {
        this.addBuffer(bufferProvider.getBuffer());
    }

    @Override
    protected void addBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.mark = -1;
    }

    @Override
    public void resetAt(int bytesToSkip, AbstractBytesInputStream stream) throws IOException {
        ByteBufferInputStream in = (ByteBufferInputStream)stream;
        this.buffer = in.buffer.duplicate();
        this.buffer.position(this.buffer.position() + bytesToSkip);
        this.mark = -1;
    }

    @Override
    public void read(IPointable pointable, int length) throws EOFException {
        if (this.buffer.remaining() < length) {
            throw new EOFException();
        }
        pointable.set(this.buffer.array(), this.buffer.position(), length);
        this.buffer.position(this.buffer.position() + length);
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            throw new EOFException();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int remaining = this.buffer.remaining();
        if (remaining <= 0) {
            return -1;
        }
        int bytesToRead = Math.min(remaining, length);
        this.buffer.get(bytes, offset, bytesToRead);
        return bytesToRead;
    }

    @Override
    public long skip(long n) {
        if (n == 0L) {
            return 0L;
        }
        if (!this.buffer.hasRemaining()) {
            return -1L;
        }
        int bytesToSkip = (int)Math.min((long)this.buffer.remaining(), n);
        this.buffer.position(this.buffer.position() + bytesToSkip);
        return bytesToSkip;
    }

    @Override
    public int read(ByteBuffer out) {
        ByteBuffer copyBuffer;
        int bytesToCopy;
        if (this.buffer.remaining() <= out.remaining()) {
            bytesToCopy = this.buffer.remaining();
            copyBuffer = this.buffer;
        } else {
            bytesToCopy = out.remaining();
            copyBuffer = this.buffer.duplicate();
            copyBuffer.position(this.buffer.position());
            copyBuffer.limit(this.buffer.position() + bytesToCopy);
            this.buffer.position(this.buffer.position() + bytesToCopy);
        }
        out.put(copyBuffer);
        out.flip();
        return bytesToCopy;
    }

    @Override
    public AbstractBytesInputStream sliceStream(int length) throws EOFException {
        if (this.buffer.remaining() < length) {
            throw new EOFException();
        }
        ByteBuffer copy = this.buffer.duplicate();
        copy.position(this.buffer.position());
        copy.limit(this.buffer.position() + length);
        ByteBufferInputStream in = new ByteBufferInputStream();
        in.addBuffer(copy);
        this.buffer.position(this.buffer.position() + length);
        return in;
    }

    @Override
    public AbstractBytesInputStream remainingStream() {
        ByteBuffer remaining = this.buffer.duplicate();
        remaining.position(this.buffer.position());
        this.buffer.position(this.buffer.limit());
        ByteBufferInputStream in = new ByteBufferInputStream();
        in.addBuffer(remaining);
        return in;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.buffer.position();
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0) {
            throw new IOException("No mark defined");
        }
        this.buffer.position(this.mark);
        this.mark = -1;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

