/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.out;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.column.bytes.stream.out.AbstractBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.pointer.ByteBufferReservedPointer;
import org.apache.asterix.column.bytes.stream.out.pointer.IReservedPointer;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;

abstract class AbstractMultiBufferBytesOutputStream
extends AbstractBytesOutputStream {
    protected final Mutable<IColumnWriteMultiPageOp> multiPageOpRef;
    protected final List<ByteBuffer> buffers;
    protected int currentBufferIndex;
    protected int allocatedBytes;
    protected int position;
    protected ByteBuffer currentBuf;

    AbstractMultiBufferBytesOutputStream(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.multiPageOpRef = multiPageOpRef;
        this.buffers = new ArrayList<ByteBuffer>();
    }

    protected abstract ByteBuffer confiscateNewBuffer() throws HyracksDataException;

    protected abstract void preReset() throws HyracksDataException;

    @Override
    public final void reset() throws HyracksDataException {
        this.preReset();
        this.position = 0;
        this.currentBufferIndex = 0;
        if (this.allocatedBytes == 0) {
            this.allocateBuffer();
        }
        this.currentBufferIndex = 0;
        this.currentBuf = this.buffers.get(0);
        this.currentBuf.clear();
    }

    @Override
    public final void write(int b) throws IOException {
        this.ensureCapacity(1);
        this.currentBuf.put((byte)b);
        ++this.position;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        int writeLength;
        this.ensureCapacity(len);
        int offset = off;
        for (int remaining = len; remaining > 0; remaining -= writeLength) {
            this.setNextBufferIfNeeded();
            writeLength = Math.min(remaining, this.currentBuf.remaining());
            this.currentBuf.put(b, offset, writeLength);
            this.position += writeLength;
            offset += writeLength;
        }
    }

    @Override
    public void reserveByte(IReservedPointer pointer) throws IOException {
        this.ensureCapacity(1);
        int offset = this.getCurrentBufferPosition();
        this.currentBuf.put((byte)0);
        ++this.position;
        ((ByteBufferReservedPointer)pointer).setPointer(this.currentBuf, offset);
    }

    @Override
    public final void reserveInteger(IReservedPointer pointer) throws HyracksDataException {
        this.ensureCapacity(4);
        int offset = this.getCurrentBufferPosition();
        this.currentBuf.putInt(0);
        this.position += 4;
        ((ByteBufferReservedPointer)pointer).setPointer(this.currentBuf, offset);
    }

    @Override
    public final IReservedPointer createPointer() {
        return new ByteBufferReservedPointer();
    }

    public final int getCurrentBufferPosition() {
        return this.currentBuf.position();
    }

    @Override
    public final int size() {
        return this.position;
    }

    @Override
    public final int capacity() {
        return this.allocatedBytes;
    }

    @Override
    public final void finish() {
        this.currentBuf = null;
        this.buffers.clear();
        this.allocatedBytes = 0;
    }

    private void ensureCapacity(int length) throws HyracksDataException {
        if (this.position + length > this.allocatedBytes) {
            this.allocateMoreBuffers(length);
        } else if (length > 0) {
            this.setNextBufferIfNeeded();
        }
    }

    private void allocateMoreBuffers(int length) throws HyracksDataException {
        for (int neededSpace = length - this.currentBuf.remaining(); neededSpace > 0; neededSpace -= this.allocateBuffer()) {
        }
        this.setNextBufferIfNeeded();
    }

    private void setNextBufferIfNeeded() {
        if (this.currentBuf.remaining() == 0) {
            this.currentBuf = this.buffers.get(++this.currentBufferIndex);
            this.currentBuf.clear();
        }
    }

    private int allocateBuffer() throws HyracksDataException {
        ByteBuffer buffer = this.confiscateNewBuffer();
        this.buffers.add(buffer);
        buffer.clear();
        int size = buffer.capacity();
        this.allocatedBytes += size;
        return size;
    }
}

