/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.query;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.asterix.column.assembler.value.MissingValueGetter;
import org.apache.asterix.column.assembler.value.ValueGetterFactory;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluatorFactory;
import org.apache.asterix.column.filter.range.IColumnRangeFilterEvaluatorFactory;
import org.apache.asterix.column.operation.query.QueryColumnMetadata;
import org.apache.asterix.column.tuple.AssembledTupleReference;
import org.apache.asterix.column.tuple.QueryColumnTupleReference;
import org.apache.asterix.column.values.reader.ColumnValueReaderFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnTupleProjector;

public class QueryColumnTupleProjector
implements IColumnTupleProjector {
    protected final ARecordType datasetType;
    protected final ARecordType requestedType;
    protected final int numberOfPrimaryKeys;
    protected final Map<String, FunctionCallInformation> functionCallInfoMap;
    protected final IWarningCollector warningCollector;
    protected final IHyracksTaskContext context;
    protected final IColumnRangeFilterEvaluatorFactory normalizedFilterEvaluatorFactory;
    protected final IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory;
    private final AssembledTupleReference assembledTupleReference;

    public QueryColumnTupleProjector(ARecordType datasetType, int numberOfPrimaryKeys, ARecordType requestedType, Map<String, FunctionCallInformation> functionCallInfoMap, IColumnRangeFilterEvaluatorFactory normalizedFilterEvaluatorFactory, IColumnIterableFilterEvaluatorFactory columnFilterEvaluatorFactory, IWarningCollector warningCollector, IHyracksTaskContext context) {
        this.datasetType = datasetType;
        this.numberOfPrimaryKeys = numberOfPrimaryKeys;
        this.requestedType = requestedType;
        this.functionCallInfoMap = functionCallInfoMap;
        this.normalizedFilterEvaluatorFactory = normalizedFilterEvaluatorFactory;
        this.columnFilterEvaluatorFactory = columnFilterEvaluatorFactory;
        this.warningCollector = warningCollector;
        this.context = context;
        this.assembledTupleReference = new AssembledTupleReference(this.getNumberOfTupleFields());
    }

    public IColumnProjectionInfo createProjectionInfo(IValueReference serializedMetadata) throws HyracksDataException {
        try {
            return QueryColumnMetadata.create(this.datasetType, this.numberOfPrimaryKeys, serializedMetadata, new ColumnValueReaderFactory(), ValueGetterFactory.INSTANCE, this.requestedType, this.functionCallInfoMap, this.normalizedFilterEvaluatorFactory, this.columnFilterEvaluatorFactory, this.warningCollector, this.context);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public final ITupleReference project(ITupleReference tuple, DataOutput dos, ArrayTupleBuilder tb) throws IOException {
        for (int i = 0; i < this.numberOfPrimaryKeys; ++i) {
            dos.write(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            tb.addFieldEndOffset();
        }
        if (this.isColumnar(tuple)) {
            IValueReference assembledRecord = this.getAssembledValue(tuple);
            if (assembledRecord == MissingValueGetter.MISSING) {
                return null;
            }
            dos.write(assembledRecord.getByteArray(), assembledRecord.getStartOffset(), assembledRecord.getLength());
        } else {
            dos.write(tuple.getFieldData(this.numberOfPrimaryKeys), tuple.getFieldStart(this.numberOfPrimaryKeys), tuple.getFieldLength(this.numberOfPrimaryKeys));
        }
        tb.addFieldEndOffset();
        this.writeMeta(tuple, dos, tb);
        return this.assembledTupleReference.reset(tb);
    }

    protected boolean isColumnar(ITupleReference tuple) {
        return tuple instanceof QueryColumnTupleReference;
    }

    protected IValueReference getAssembledValue(ITupleReference tuple) throws HyracksDataException {
        QueryColumnTupleReference columnTuple = (QueryColumnTupleReference)tuple;
        return columnTuple.getAssembledValue();
    }

    protected void writeMeta(ITupleReference tuple, DataOutput dos, ArrayTupleBuilder tb) throws IOException {
    }

    protected int getNumberOfTupleFields() {
        return this.numberOfPrimaryKeys + 1;
    }
}

