/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.util;

import org.apache.asterix.om.types.ATypeTag;

public class ColumnValuesUtil {
    private ColumnValuesUtil() {
    }

    public static int getBitWidth(int level) {
        return 32 - Integer.numberOfLeadingZeros(level) + 1;
    }

    public static int getNullMask(int level) {
        return 1 << ColumnValuesUtil.getBitWidth(level) - 1;
    }

    public static boolean isNull(int mask, int level) {
        return (mask & level) == mask;
    }

    public static int getChildValue(int parentMask, int childMask, int level) {
        if (ColumnValuesUtil.isNull(parentMask, level)) {
            return ColumnValuesUtil.clearNullBit(parentMask, level) | childMask;
        }
        return level;
    }

    public static int clearNullBit(int nullBitMask, int level) {
        return nullBitMask - 1 & level;
    }

    public static ATypeTag getNormalizedTypeTag(ATypeTag typeTag) {
        switch (typeTag) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return ATypeTag.BIGINT;
            }
        }
        return typeTag;
    }
}

