/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples.ColumnMultiBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples.ColumnSingleBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.lsm.tuples.DummyColumnBufferProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractColumnTupleReference
implements IColumnTupleIterator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String UNSUPPORTED_OPERATION_MSG = "Operation is not supported for column tuples";
    private final int componentIndex;
    private final ColumnBTreeReadLeafFrame frame;
    private final IColumnBufferProvider[] primaryKeyBufferProviders;
    private final IColumnBufferProvider[] filterBufferProviders;
    private final IColumnBufferProvider[] buffersProviders;
    private final int numberOfPrimaryKeys;
    private int endIndex;
    protected int tupleIndex;
    private final LongSet pinnedPages;
    private int totalNumberOfMegaLeafNodes;
    private int numOfSkippedMegaLeafNodes;
    private int maxNumberOfPinnedPages;

    protected AbstractColumnTupleReference(int componentIndex, ColumnBTreeReadLeafFrame frame, IColumnProjectionInfo info, IColumnReadMultiPageOp multiPageOp) {
        this.componentIndex = componentIndex;
        this.frame = frame;
        this.numberOfPrimaryKeys = info.getNumberOfPrimaryKeys();
        this.primaryKeyBufferProviders = new IColumnBufferProvider[this.numberOfPrimaryKeys];
        for (int i = 0; i < this.numberOfPrimaryKeys; ++i) {
            this.primaryKeyBufferProviders[i] = new ColumnSingleBufferProvider(i);
        }
        this.pinnedPages = new LongOpenHashSet();
        int numberOfFilteredColumns = info.getNumberOfFilteredColumns();
        this.filterBufferProviders = new IColumnBufferProvider[numberOfFilteredColumns];
        for (int i = 0; i < numberOfFilteredColumns; ++i) {
            int columnIndex = info.getFilteredColumnIndex(i);
            this.filterBufferProviders[i] = columnIndex < 0 ? DummyColumnBufferProvider.INSTANCE : (columnIndex >= this.numberOfPrimaryKeys ? new ColumnMultiBufferProvider(columnIndex, multiPageOp, this.pinnedPages) : new ColumnSingleBufferProvider(columnIndex));
        }
        int numberOfRequestedColumns = info.getNumberOfProjectedColumns();
        this.buffersProviders = new IColumnBufferProvider[numberOfRequestedColumns];
        for (int i = 0; i < numberOfRequestedColumns; ++i) {
            int columnIndex = info.getColumnIndex(i);
            this.buffersProviders[i] = columnIndex >= this.numberOfPrimaryKeys ? new ColumnMultiBufferProvider(columnIndex, multiPageOp, this.pinnedPages) : DummyColumnBufferProvider.INSTANCE;
        }
        this.totalNumberOfMegaLeafNodes = 0;
        this.numOfSkippedMegaLeafNodes = 0;
    }

    @Override
    public final void newPage() throws HyracksDataException {
        this.tupleIndex = 0;
        ByteBuffer pageZero = this.frame.getBuffer();
        pageZero.clear();
        pageZero.position(30);
        int numberOfTuples = this.frame.getTupleCount();
        for (int i = 0; i < this.numberOfPrimaryKeys; ++i) {
            IColumnBufferProvider provider = this.primaryKeyBufferProviders[i];
            provider.reset(this.frame);
            this.startPrimaryKey(provider, i, numberOfTuples);
        }
    }

    @Override
    public final void reset(int startIndex, int endIndex) throws HyracksDataException {
        IColumnBufferProvider provider;
        int i;
        this.tupleIndex = startIndex;
        this.endIndex = endIndex;
        ByteBuffer pageZero = this.frame.getBuffer();
        int numberOfTuples = this.frame.getTupleCount();
        boolean readColumnPages = this.startNewPage(pageZero, this.frame.getNumberOfColumns(), numberOfTuples);
        this.unpinColumnsPages();
        int skipCount = this.setPrimaryKeysAt(startIndex, startIndex);
        if (readColumnPages) {
            for (i = 0; i < this.filterBufferProviders.length; ++i) {
                provider = this.filterBufferProviders[i];
                provider.reset(this.frame);
                this.startColumnFilter(provider, i, numberOfTuples);
            }
        }
        if (readColumnPages && this.evaluateFilter()) {
            for (i = 0; i < this.buffersProviders.length; ++i) {
                provider = this.buffersProviders[i];
                provider.reset(this.frame);
                this.startColumn(provider, i, numberOfTuples);
            }
            this.skip(Math.max(skipCount, 0));
        } else {
            ++this.numOfSkippedMegaLeafNodes;
        }
        ++this.totalNumberOfMegaLeafNodes;
    }

    @Override
    public final void setAt(int startIndex) throws HyracksDataException {
        if (this.tupleIndex == startIndex) {
            return;
        }
        int skipCount = startIndex - this.tupleIndex - 1;
        this.tupleIndex = startIndex;
        skipCount = this.setPrimaryKeysAt(startIndex, skipCount);
        this.skip(skipCount);
    }

    protected abstract int setPrimaryKeysAt(int var1, int var2) throws HyracksDataException;

    protected abstract boolean startNewPage(ByteBuffer var1, int var2, int var3) throws HyracksDataException;

    protected abstract void startPrimaryKey(IColumnBufferProvider var1, int var2, int var3) throws HyracksDataException;

    protected abstract void startColumn(IColumnBufferProvider var1, int var2, int var3) throws HyracksDataException;

    protected abstract void startColumnFilter(IColumnBufferProvider var1, int var2, int var3) throws HyracksDataException;

    protected abstract boolean evaluateFilter() throws HyracksDataException;

    protected abstract void onNext() throws HyracksDataException;

    public final int getTupleCount() {
        return this.frame.getTupleCount();
    }

    protected final boolean isEmpty() {
        return this.frame.getTupleCount() == 0;
    }

    @Override
    public final void next() throws HyracksDataException {
        this.onNext();
        ++this.tupleIndex;
    }

    @Override
    public final void consume() {
        this.tupleIndex = this.frame.getTupleCount();
    }

    @Override
    public final boolean isConsumed() {
        return this.tupleIndex >= this.endIndex;
    }

    @Override
    public final int getComponentIndex() {
        return this.componentIndex;
    }

    @Override
    public final void unpinColumnsPages() throws HyracksDataException {
        int i;
        for (i = 0; i < this.filterBufferProviders.length; ++i) {
            this.filterBufferProviders[i].releaseAll();
        }
        for (i = 0; i < this.buffersProviders.length; ++i) {
            this.buffersProviders[i].releaseAll();
        }
        this.maxNumberOfPinnedPages = Math.max(this.maxNumberOfPinnedPages, this.pinnedPages.size());
        this.pinnedPages.clear();
    }

    @Override
    public final void close() {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        if (this.numOfSkippedMegaLeafNodes > 0) {
            LOGGER.debug("Filtered {} disk mega-leaf nodes out of {} in total", (Object)this.numOfSkippedMegaLeafNodes, (Object)this.totalNumberOfMegaLeafNodes);
        }
        LOGGER.debug("Max number of pinned pages is {}", (Object)(this.maxNumberOfPinnedPages + 1));
    }

    public final void setFieldCount(int fieldCount) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG);
    }

    public final void setFieldCount(int fieldStartIndex, int fieldCount) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG);
    }

    public final void resetByTupleOffset(byte[] buf, int tupleStartOffset) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG);
    }

    public final void resetByTupleIndex(ITreeIndexFrame frame, int tupleIndex) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MSG);
    }
}

