/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.win.AbstractWindowPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowPartitionReader;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowPartitionWriter;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;

class WindowMaterializingPushRuntime
extends AbstractWindowPushRuntime {
    private final int memSizeInFrames;
    private long partitionLength;
    private WindowPartitionWriter partitionWriter;
    WindowPartitionReader partitionReader;
    private int chunkBeginIdx;
    private IntArrayList chunkEndIdx;

    WindowMaterializingPushRuntime(int[] partitionColumns, IBinaryComparatorFactory[] partitionComparatorFactories, IBinaryComparatorFactory[] orderComparatorFactories, int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, IHyracksTaskContext ctx, int memSizeInFrames, SourceLocation sourceLoc) {
        super(partitionColumns, partitionComparatorFactories, orderComparatorFactories, projectionColumns, runningAggOutColumns, runningAggFactories, ctx, sourceLoc);
        this.memSizeInFrames = memSizeInFrames;
    }

    @Override
    protected void init() throws HyracksDataException {
        super.init();
        String runFilePrefix = this.getClass().getName();
        this.partitionWriter = new WindowPartitionWriter(this.ctx.getTaskContext(), this.memSizeInFrames - this.getReservedFrameCount(), runFilePrefix, this.getPartitionReaderSlotCount(), this.sourceLoc);
        this.partitionReader = this.partitionWriter.getReader();
        this.chunkEndIdx = new IntArrayList(128, 128);
    }

    @Override
    public void close() throws HyracksDataException {
        super.close();
        if (this.partitionWriter != null) {
            this.partitionWriter.close();
        }
    }

    @Override
    protected void beginPartitionImpl() throws HyracksDataException {
        this.chunkEndIdx.clear();
        this.partitionLength = 0L;
        this.partitionWriter.reset();
    }

    @Override
    protected void partitionChunkImpl(long frameId, ByteBuffer frameBuffer, int tBeginIdx, int tEndIdx) throws HyracksDataException {
        boolean isFirstChunk = this.chunkEndIdx.isEmpty();
        this.partitionWriter.nextFrame(frameId, frameBuffer);
        if (isFirstChunk) {
            this.chunkBeginIdx = tBeginIdx;
        }
        this.chunkEndIdx.add(tEndIdx);
        this.partitionLength += (long)(tEndIdx - tBeginIdx + 1);
    }

    @Override
    protected void endPartitionImpl() throws HyracksDataException {
        this.runningAggInitPartition(this.partitionLength);
        this.partitionReader.open();
        int nChunks = this.getPartitionChunkCount();
        for (int chunkIdx = 0; chunkIdx < nChunks; ++chunkIdx) {
            IFrame chunkFrame = this.partitionReader.nextFrame(true);
            this.producePartitionTuples(chunkIdx, chunkFrame);
        }
        this.partitionReader.close();
    }

    void producePartitionTuples(int chunkIdx, IFrame chunkFrame) throws HyracksDataException {
        this.tAccess.reset(chunkFrame.getBuffer());
        this.produceTuples((IFrameTupleAccessor)this.tAccess, this.getTupleBeginIdx(chunkIdx), this.getTupleEndIdx(chunkIdx), this.tRef);
    }

    final int getPartitionChunkCount() {
        return this.chunkEndIdx.size();
    }

    final int getTupleBeginIdx(int chunkIdx) {
        return chunkIdx == 0 ? this.chunkBeginIdx : 0;
    }

    final int getTupleEndIdx(int chunkIdx) {
        return this.chunkEndIdx.get(chunkIdx);
    }

    int getPartitionReaderSlotCount() {
        return -1;
    }
}

