/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.recordgroup;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.asterix.fuzzyjoin.recordgroup.RecordGroup;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFilters;

public class RecordGroupLengthRange
extends RecordGroup {
    private final int min;
    private final int max;
    private final int groupSize;

    public RecordGroupLengthRange(int noGroups, SimilarityFilters fuzzyFilters, String lengthstatsPath) {
        super(noGroups, fuzzyFilters);
        try (DataInputStream in = new DataInputStream(new FileInputStream(lengthstatsPath));){
            this.min = in.readInt();
            this.max = in.readInt();
            this.groupSize = (int)Math.ceil(((float)(this.max - this.min) + 1.0f) / (float)noGroups);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public Iterable<Integer> getGroups(Integer token, Integer length) {
        int lowAbs = this.fuzzyFilters.getLengthLowerBound(length);
        int uppAbs = this.fuzzyFilters.getLengthUpperBound(length);
        int low = Math.max(lowAbs - this.min, 0);
        int upp = Math.min(uppAbs - this.min, this.max - this.min);
        ArrayList<Integer> groups = new ArrayList<Integer>(upp - low + 1);
        int prevGroup = -1;
        for (int l = low; l <= upp; ++l) {
            int group = l / this.groupSize;
            if (group == prevGroup) continue;
            groups.add(group);
            prevGroup = group;
        }
        return groups;
    }

    @Override
    public boolean isLengthOnly() {
        return true;
    }
}

