/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.cbo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.compiler.provider.IRuleSetFactory;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.literal.StringLiteral;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.declared.SampleDataSource;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.asterix.optimizer.rules.am.array.AbstractOperatorFromSubplanRewrite;
import org.apache.asterix.optimizer.rules.cbo.ContainsExpressionVisitor;
import org.apache.asterix.optimizer.rules.cbo.JoinEnum;
import org.apache.asterix.translator.ConstantHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.JoinProductivityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.PredicateCardinalityAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Stats {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IOptimizationContext optCtx;
    private final JoinEnum joinEnum;
    private long totalCardFromSample;
    private double distinctCardFromSample;
    private final long MIN_TOTAL_SAMPLES = 1L;

    public void setTotalCardFromSample(long numSamples) {
        this.totalCardFromSample = numSamples;
    }

    public void setDistinctCardFromSample(double numDistinctSamples) {
        this.distinctCardFromSample = numDistinctSamples;
    }

    public Stats(IOptimizationContext context, JoinEnum joinE) {
        this.optCtx = context;
        this.joinEnum = joinE;
    }

    protected Index findSampleIndex(DataSourceScanOperator scanOp, IOptimizationContext context) throws AlgebricksException {
        DataSource ds = (DataSource)scanOp.getDataSource();
        if (ds.getDatasourceType() != 0) {
            return null;
        }
        DataSourceId dsid = ds.getId();
        MetadataProvider mdp = (MetadataProvider)context.getMetadataProvider();
        return mdp.findSampleIndex(dsid.getDatabaseName(), dsid.getDataverseName(), dsid.getDatasourceName());
    }

    private double findJoinSelectivity(JoinProductivityAnnotation anno, AbstractFunctionCallExpression joinExpr) throws AlgebricksException {
        ArrayList exprUsedVars = new ArrayList();
        joinExpr.getUsedVariables(exprUsedVars);
        if (exprUsedVars.size() != 2) {
            return 1.0;
        }
        if (!this.joinEnum.varLeafInputIds.containsKey(exprUsedVars.get(0))) {
            return 1.0;
        }
        int idx1 = this.joinEnum.varLeafInputIds.get(exprUsedVars.get(0));
        if (!this.joinEnum.varLeafInputIds.containsKey(exprUsedVars.get(1))) {
            return 1.0;
        }
        int idx2 = this.joinEnum.varLeafInputIds.get(exprUsedVars.get(1));
        double card1 = this.joinEnum.getJnArray()[idx1].origCardinality;
        double card2 = this.joinEnum.getJnArray()[idx2].origCardinality;
        if (card1 == 0.0 || card2 == 0.0) {
            return 1.0;
        }
        if (anno != null) {
            int leftIndex = this.joinEnum.findJoinNodeIndexByName(anno.getLeftSideDataSet());
            if (leftIndex != idx1 && leftIndex != idx2) {
                IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
                if (warningCollector.shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)joinExpr.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"productivity", "Invalid collection name/alias: " + anno.getLeftSideDataSet()}));
                }
                return 1.0;
            }
            double productivity = anno.getJoinProductivity();
            if (productivity <= 0.0) {
                IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
                if (warningCollector.shouldWarn()) {
                    warningCollector.warn(Warning.of((SourceLocation)joinExpr.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"productivity", "Productivity specified: " + productivity + ", has to be a decimal value greater than 0"}));
                }
                return 1.0;
            }
            if (leftIndex == idx1) {
                return productivity / card2;
            }
            return productivity / card1;
        }
        if (card1 < card2) {
            return 1.0 / card1;
        }
        return 1.0 / card2;
    }

    private double getSelectivityFromAnnotation(AbstractFunctionCallExpression afcExpr, boolean join, boolean singleDatasetPreds) throws AlgebricksException {
        ILogicalExpression lexpr;
        double sel = 1.0;
        if (afcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.OR)) {
            double orSel = 0.0;
            for (int i = 0; i < afcExpr.getArguments().size(); ++i) {
                ILogicalExpression lexpr2 = (ILogicalExpression)((Mutable)afcExpr.getArguments().get(i)).getValue();
                if (!lexpr2.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
                sel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(i)).getValue(), join, singleDatasetPreds);
                orSel = orSel + sel - orSel * sel;
            }
            return orSel;
        }
        if (afcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.AND)) {
            double andSel = 1.0;
            for (int i = 0; i < afcExpr.getArguments().size(); ++i) {
                ILogicalExpression lexpr3 = (ILogicalExpression)((Mutable)afcExpr.getArguments().get(i)).getValue();
                if (!lexpr3.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
                sel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(i)).getValue(), join, singleDatasetPreds);
                andSel *= sel;
            }
            return andSel;
        }
        if (afcExpr.getFunctionIdentifier().equals((Object)AlgebricksBuiltinFunctions.NOT) && (lexpr = (ILogicalExpression)((Mutable)afcExpr.getArguments().get(0)).getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            sel = this.getSelectivityFromAnnotation((AbstractFunctionCallExpression)((Mutable)afcExpr.getArguments().get(0)).getValue(), join, singleDatasetPreds);
            return sel == 1.0 ? 1.0 : 1.0 - sel;
        }
        PredicateCardinalityAnnotation pca = (PredicateCardinalityAnnotation)afcExpr.getAnnotation(PredicateCardinalityAnnotation.class);
        if (!join) {
            if (pca != null) {
                double s = pca.getSelectivity();
                if (s <= 0.0 || s >= 1.0) {
                    IWarningCollector warningCollector = this.joinEnum.optCtx.getWarningCollector();
                    if (warningCollector.shouldWarn()) {
                        warningCollector.warn(Warning.of((SourceLocation)afcExpr.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"selectivity", "Selectivity specified: " + s + ", has to be a decimal value greater than 0 and less than 1"}));
                    }
                } else {
                    sel *= s;
                }
            } else if (singleDatasetPreds) {
                return -1.0;
            }
        } else {
            JoinProductivityAnnotation jpa = (JoinProductivityAnnotation)afcExpr.getAnnotation(JoinProductivityAnnotation.class);
            double s = this.findJoinSelectivity(jpa, afcExpr);
            sel *= s;
        }
        ArrayList usedVars = new ArrayList();
        usedVars.clear();
        afcExpr.getUsedVariables(usedVars);
        if (join && sel == 1.0 && usedVars.size() == 1) {
            this.joinEnum.singleDatasetPreds.add((ILogicalExpression)afcExpr);
        }
        return sel;
    }

    protected double getSelectivityFromAnnotationMain(ILogicalExpression leExpr, boolean join, boolean singleDatasetPreds) throws AlgebricksException {
        double sel = 1.0;
        if (leExpr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            AbstractFunctionCallExpression afcExpr = (AbstractFunctionCallExpression)leExpr;
            sel = this.getSelectivityFromAnnotation(afcExpr, join, singleDatasetPreds);
        }
        return sel;
    }

    protected double getSelectivity(ILogicalOperator op, boolean join) throws AlgebricksException {
        double sel = 1.0;
        if (op == null) {
            return sel;
        }
        while (op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selOper = (SelectOperator)op;
                sel *= this.getSelectivityFromAnnotationMain((ILogicalExpression)selOper.getCondition().getValue(), join, false);
            }
            if (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                sel *= this.getSelectivity((SubplanOperator)op);
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return sel;
    }

    private double getSelectivity(SubplanOperator subplanOp) throws AlgebricksException {
        double sel = 1.0;
        ILogicalOperator op = (ILogicalOperator)((Mutable)((ILogicalPlan)subplanOp.getNestedPlans().get(0)).getRoots().get(0)).getValue();
        while (true) {
            if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
                SelectOperator selOper = (SelectOperator)op;
                sel *= this.getSelectivityFromAnnotationMain((ILogicalExpression)selOper.getCondition().getValue(), false, false);
            }
            if (op.getInputs().size() <= 0) break;
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return sel;
    }

    private List<ILogicalOperator> countOps(ILogicalOperator op, LogicalOperatorTag tag) {
        ArrayList<ILogicalOperator> ops = new ArrayList<ILogicalOperator>();
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (op.getOperatorTag().equals((Object)tag)) {
                ops.add(op);
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return ops;
    }

    private AggregateOperator findAggOp(ILogicalOperator op, ILogicalExpression exp) throws AlgebricksException {
        ContainsExpressionVisitor visitor = new ContainsExpressionVisitor();
        while (op != null && op.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            SubplanOperator subOp;
            ILogicalOperator nextOp;
            if (op.getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN) && (nextOp = (ILogicalOperator)((Mutable)((ILogicalPlan)(subOp = (SubplanOperator)op).getNestedPlans().get(0)).getRoots().get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
                return (AggregateOperator)nextOp;
            }
            op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        }
        return null;
    }

    protected SelectOperator findSelectOpWithExpr(ILogicalOperator op, ILogicalExpression exp) throws AlgebricksException {
        ContainsExpressionVisitor visitor = new ContainsExpressionVisitor();
        ILogicalOperator currentOp = op;
        while (currentOp != null && currentOp.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            if (currentOp.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
                ILogicalOperator nextOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
                if (nextOp.getOperatorTag().equals((Object)LogicalOperatorTag.SUBPLAN)) {
                    SubplanOperator subOp = (SubplanOperator)nextOp;
                    ILogicalOperator childOp = (ILogicalOperator)((Mutable)((ILogicalPlan)subOp.getNestedPlans().get(0)).getRoots().get(0)).getValue();
                    while (childOp != null) {
                        visitor.setExpression(exp);
                        if (childOp.acceptExpressionTransform((ILogicalExpressionReferenceTransform)visitor)) {
                            return (SelectOperator)currentOp;
                        }
                        if (!childOp.getInputs().isEmpty()) {
                            childOp = (ILogicalOperator)((Mutable)childOp.getInputs().get(0)).getValue();
                            continue;
                        }
                        break;
                    }
                } else {
                    visitor.setExpression(exp);
                    if (currentOp.acceptExpressionTransform((ILogicalExpressionReferenceTransform)visitor)) {
                        return (SelectOperator)currentOp;
                    }
                }
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        return null;
    }

    private List<ILogicalExpression> storeSelectConditionsAndMakeThemTrue(ILogicalOperator op, SelectOperator otherSelOp) {
        ArrayList<ILogicalExpression> selExprs = new ArrayList<ILogicalExpression>();
        ILogicalOperator currentOp = op;
        while (currentOp != null && currentOp.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            SelectOperator selOp;
            if (currentOp.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT) && (selOp = (SelectOperator)currentOp) != otherSelOp) {
                selExprs.add((ILogicalExpression)selOp.getCondition().getValue());
                selOp.getCondition().setValue((Object)ConstantExpression.TRUE);
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
        return selExprs;
    }

    private void restoreAllSelectConditions(ILogicalOperator op, List<ILogicalExpression> selExprs, ILogicalOperator otherSelOp) {
        int i = 0;
        ILogicalOperator currentOp = op;
        while (currentOp != null && currentOp.getOperatorTag() != LogicalOperatorTag.EMPTYTUPLESOURCE) {
            SelectOperator selOp;
            if (currentOp.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT) && (selOp = (SelectOperator)currentOp) != otherSelOp) {
                selOp.getCondition().setValue((Object)selExprs.get(i));
                ++i;
            }
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
        }
    }

    protected double findSelectivityForThisPredicate(SelectOperator selOp, AbstractFunctionCallExpression exp, boolean arrayIndex) throws AlgebricksException {
        List<List<IAObject>> result;
        ILogicalOperator parent = this.joinEnum.findDataSourceScanOperatorParent((ILogicalOperator)selOp);
        DataSourceScanOperator scanOp = (DataSourceScanOperator)((Mutable)parent.getInputs().get(0)).getValue();
        if (scanOp == null) {
            return 1.0;
        }
        Index index = this.findSampleIndex(scanOp, this.optCtx);
        if (index == null) {
            return 1.0;
        }
        Index.SampleIndexDetails idxDetails = (Index.SampleIndexDetails)index.getIndexDetails();
        double origDatasetCard = idxDetails.getSourceCardinality();
        double sampleCard = Math.min((double)idxDetails.getSampleCardinalityTarget(), origDatasetCard);
        if (sampleCard == 0.0) {
            sampleCard = 1.0;
            IWarningCollector warningCollector = this.optCtx.getWarningCollector();
            if (warningCollector.shouldWarn()) {
                warningCollector.warn(Warning.of((SourceLocation)scanOp.getSourceLocation(), (IError)org.apache.asterix.common.exceptions.ErrorCode.SAMPLE_HAS_ZERO_ROWS, (Serializable[])new Serializable[0]));
            }
        }
        SampleDataSource sampledatasource = this.joinEnum.getSampleDataSource(scanOp);
        DataSourceScanOperator deepCopyofScan = (DataSourceScanOperator)OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)scanOp);
        deepCopyofScan.setDataSource((IDataSource)sampledatasource);
        List<ILogicalOperator> subPlans = this.countOps((ILogicalOperator)selOp, LogicalOperatorTag.SUBPLAN);
        int numSubplans = subPlans.size();
        List<ILogicalOperator> selOps = this.countOps((ILogicalOperator)selOp, LogicalOperatorTag.SELECT);
        int numSelects = selOps.size();
        int nonSubplanSelects = numSelects - numSubplans;
        ((Mutable)parent.getInputs().get(0)).setValue((Object)deepCopyofScan);
        if (numSubplans == 1 && nonSubplanSelects == 0) {
            AggregateOperator aggOp = this.findAggOp((ILogicalOperator)selOp, (ILogicalExpression)exp);
            if (aggOp.getExpressions().size() > 1) {
                SelectOperator newSelOp = (SelectOperator)OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)selOp);
                aggOp = this.findAggOp((ILogicalOperator)newSelOp, (ILogicalExpression)exp);
                ILogicalOperator input = (ILogicalOperator)((Mutable)aggOp.getInputs().get(0)).getValue();
                SelectOperator condition = (SelectOperator)OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)AbstractOperatorFromSubplanRewrite.getSelectFromPlan(aggOp));
                ((Mutable)aggOp.getInputs().get(0)).setValue((Object)condition);
                ((Mutable)condition.getInputs().get(0)).setValue((Object)input);
                ILogicalExpression newExp2 = (ILogicalExpression)newSelOp.getCondition().getValue();
                if (newExp2.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                    AbstractFunctionCallExpression afce = (AbstractFunctionCallExpression)newExp2;
                    ((Mutable)afce.getArguments().get(1)).setValue((Object)ConstantExpression.TRUE);
                }
                result = this.runSamplingQuery(this.optCtx, (ILogicalOperator)newSelOp);
            } else {
                result = this.runSamplingQuery(this.optCtx, (ILogicalOperator)selOp);
            }
        } else {
            SelectOperator selOp2 = this.findSelectOpWithExpr((ILogicalOperator)selOp, (ILogicalExpression)exp);
            List<ILogicalExpression> selExprs = this.storeSelectConditionsAndMakeThemTrue((ILogicalOperator)selOp, selOp2);
            result = this.runSamplingQuery(this.optCtx, (ILogicalOperator)selOp);
            this.restoreAllSelectConditions((ILogicalOperator)selOp, selExprs, (ILogicalOperator)selOp2);
        }
        double predicateCardinality = this.findPredicateCardinality(result, false);
        predicateCardinality = Math.max(predicateCardinality, 1.0E-4);
        if (arrayIndex) {
            List<ILogicalExpression> selExprs = this.storeSelectConditionsAndMakeThemTrue((ILogicalOperator)selOp, null);
            result = this.runSamplingQuery(this.optCtx, (ILogicalOperator)selOp);
            this.restoreAllSelectConditions((ILogicalOperator)selOp, selExprs, null);
            sampleCard = this.findPredicateCardinality(result, false);
        }
        ((Mutable)parent.getInputs().get(0)).setValue((Object)scanOp);
        double sel = predicateCardinality / sampleCard;
        return sel;
    }

    public double findPredicateCardinality(List<List<IAObject>> result, boolean project) {
        if (project) {
            ARecord record = (ARecord)result.get(0).get(0);
            int fields = record.numberOfFields();
            IAObject first = record.getValueByPos(0);
            return ((AInt64)first).getLongValue();
        }
        return ((AInt64)result.get(0).get(0)).getLongValue();
    }

    public int numberOfFields(List<List<IAObject>> result) {
        ARecord record = (ARecord)result.get(0).get(0);
        return record.numberOfFields();
    }

    public double findSizeVarsFromDisk(List<List<IAObject>> result, int numDiskVars) {
        ARecord record = (ARecord)result.get(0).get(0);
        double projectedSize = 0.0;
        int fields = record.numberOfFields();
        for (int j = 1; j <= numDiskVars; ++j) {
            IAObject field = record.getValueByPos(j);
            double size = ((ADouble)field).getDoubleValue();
            projectedSize += size;
        }
        return projectedSize;
    }

    public double findSizeVarsAfterScan(List<List<IAObject>> result, int numDiskVars) {
        ARecord record = (ARecord)result.get(0).get(0);
        double projectedSize = 0.0;
        int fields = record.numberOfFields();
        for (int j = 1 + numDiskVars; j < fields; ++j) {
            IAObject field = record.getValueByPos(j);
            double size = ((ADouble)field).getDoubleValue();
            projectedSize += size;
        }
        return projectedSize;
    }

    protected List<List<IAObject>> runSamplingQuery(IOptimizationContext ctx, ILogicalOperator logOp) throws AlgebricksException {
        LOGGER.info("***running sample query***");
        IOptimizationContext newCtx = ctx.getOptimizationContextFactory().cloneOptimizationContext(ctx);
        ILogicalOperator newScanOp = OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)logOp);
        ArrayList<MutableObject> aggFunArgs = new ArrayList<MutableObject>(1);
        aggFunArgs.add(new MutableObject((Object)ConstantExpression.TRUE));
        BuiltinFunctionInfo countFn = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.COUNT);
        AggregateFunctionCallExpression aggExpr = new AggregateFunctionCallExpression((IFunctionInfo)countFn, false, aggFunArgs);
        ArrayList<MutableObject> aggExprList = new ArrayList<MutableObject>(1);
        aggExprList.add(new MutableObject((Object)aggExpr));
        ArrayList<LogicalVariable> aggVarList = new ArrayList<LogicalVariable>(1);
        LogicalVariable aggVar = newCtx.newVar();
        aggVarList.add(aggVar);
        AggregateOperator newAggOp = new AggregateOperator(aggVarList, aggExprList);
        newAggOp.getInputs().add(new MutableObject((Object)newScanOp));
        MutableObject newAggOpRef = new MutableObject((Object)newAggOp);
        OperatorPropertiesUtil.typeOpRec((Mutable)newAggOpRef, (IOptimizationContext)newCtx);
        LOGGER.info("***returning from sample query***");
        String viewInPlan = new ALogicalPlanImpl((Mutable)newAggOpRef).toString();
        LOGGER.trace("viewInPlan");
        LOGGER.trace(viewInPlan);
        return AnalysisUtil.runQuery((Mutable<ILogicalOperator>)newAggOpRef, Arrays.asList(aggVar), newCtx, IRuleSetFactory.RuleSetKind.SAMPLING);
    }

    protected List<List<IAObject>> runSamplingQueryProjection(IOptimizationContext ctx, ILogicalOperator logOp, int dataset, LogicalVariable primaryKey) throws AlgebricksException {
        LogicalVariable newVar;
        LOGGER.info("***running projection sample query***");
        IOptimizationContext newCtx = ctx.getOptimizationContextFactory().cloneOptimizationContext(ctx);
        ILogicalOperator newScanOp = OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)logOp);
        ArrayList vars1 = new ArrayList();
        VariableUtilities.getLiveVariables((ILogicalOperator)logOp, vars1);
        if (!this.joinEnum.resultAndJoinVars.contains(primaryKey)) {
            vars1.remove(primaryKey);
        }
        ArrayList vars3 = new ArrayList(CollectionUtils.subtract(vars1, this.joinEnum.resultAndJoinVars));
        ArrayList vars4 = new ArrayList(CollectionUtils.subtract(vars1, vars3));
        ArrayList vars = new ArrayList();
        vars.addAll(vars1);
        vars.addAll(vars4);
        this.joinEnum.jnArray[dataset].setNumVarsFromDisk(vars1.size());
        this.joinEnum.jnArray[dataset].setNumVarsAfterScan(vars4.size());
        ArrayList<LogicalVariable> newVars = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> exprs = new ArrayList<MutableObject>();
        int count = 0;
        for (LogicalVariable lv : vars) {
            ++count;
            VariableReferenceExpression varRefExpr = new VariableReferenceExpression(lv);
            ArrayList<MutableObject> vars2 = new ArrayList<MutableObject>();
            vars2.add(new MutableObject((Object)varRefExpr));
            ScalarFunctionCallExpression func = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.SERIALIZED_SIZE), vars2);
            exprs.add(new MutableObject((Object)func));
            newVar = newCtx.newVar();
            newVars.add(newVar);
        }
        AssignOperator assignOp = new AssignOperator(newVars, exprs);
        assignOp.getInputs().add(new MutableObject((Object)newScanOp));
        MutableObject tmpRef = new MutableObject((Object)assignOp);
        ArrayList<LogicalVariable> newVars2 = new ArrayList<LogicalVariable>();
        ArrayList<MutableObject> aggExprList = new ArrayList<MutableObject>();
        ArrayList<MutableObject> aggFunArgs = new ArrayList<MutableObject>(1);
        aggFunArgs.add(new MutableObject((Object)ConstantExpression.TRUE));
        BuiltinFunctionInfo countFn = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.COUNT);
        AggregateFunctionCallExpression aggExpr = new AggregateFunctionCallExpression((IFunctionInfo)countFn, false, aggFunArgs);
        aggExprList.add(new MutableObject((Object)aggExpr));
        LogicalVariable aggVar = newCtx.newVar();
        newVars2.add(aggVar);
        for (int i = 0; i < count; ++i) {
            VariableReferenceExpression varRefExpr = new VariableReferenceExpression((LogicalVariable)newVars.get(i));
            ArrayList<MutableObject> vars2 = new ArrayList<MutableObject>();
            vars2.add(new MutableObject((Object)varRefExpr));
            BuiltinFunctionInfo avgFn = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.SQL_AVG);
            aggExpr = new AggregateFunctionCallExpression((IFunctionInfo)avgFn, false, vars2);
            newVar = newCtx.newVar();
            newVars2.add(newVar);
            aggExprList.add(new MutableObject((Object)aggExpr));
        }
        AggregateOperator newAggOp = new AggregateOperator(newVars2, aggExprList);
        newAggOp.getInputs().add(new MutableObject((Object)assignOp));
        MutableObject newAggOpRef = new MutableObject((Object)newAggOp);
        OperatorPropertiesUtil.typeOpRec((Mutable)newAggOpRef, (IOptimizationContext)newCtx);
        List<MutableObject> arr = this.createMutableObjectArray(newAggOp.getVariables());
        ScalarFunctionCallExpression f = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.OPEN_RECORD_CONSTRUCTOR));
        for (int i = 0; i < arr.size(); ++i) {
            f.getArguments().add((Mutable)arr.get(i));
        }
        newVar = newCtx.newVar();
        assignOp = new AssignOperator(newVar, (Mutable)new MutableObject((Object)f));
        assignOp.getInputs().add(new MutableObject((Object)newAggOp));
        ProjectOperator pOp = new ProjectOperator(newVar);
        pOp.getInputs().add(new MutableObject((Object)assignOp));
        MutableObject Ref = new MutableObject((Object)pOp);
        OperatorPropertiesUtil.typeOpRec((Mutable)Ref, (IOptimizationContext)newCtx);
        if (LOGGER.isTraceEnabled()) {
            String viewInPlan = new ALogicalPlanImpl((Mutable)Ref).toString();
            LOGGER.trace("sampling query before calling runQuery");
            LOGGER.trace(viewInPlan);
        }
        LOGGER.info("***returning from projection sample query***");
        return AnalysisUtil.runQuery((Mutable<ILogicalOperator>)Ref, Arrays.asList(newVar), newCtx, IRuleSetFactory.RuleSetKind.SAMPLING);
    }

    private List<MutableObject> createMutableObjectArray(List<LogicalVariable> vars) {
        ArrayList<MutableObject> arr = new ArrayList<MutableObject>();
        for (int i = 0; i < vars.size(); ++i) {
            LiteralExpr le = new LiteralExpr();
            StringLiteral value = new StringLiteral("$" + Integer.toString(i + 1));
            le.setValue((Literal)value);
            AsterixConstantValue cValue = new AsterixConstantValue(ConstantHelper.objectFromLiteral(le.getValue()));
            ConstantExpression cExpr = new ConstantExpression((IAlgebricksConstantValue)cValue);
            arr.add(new MutableObject((Object)cExpr));
            arr.add(new MutableObject((Object)new VariableReferenceExpression(vars.get(i))));
        }
        return arr;
    }

    public long findDistinctCardinality(ILogicalOperator grpByDistinctOp) throws AlgebricksException {
        long distinctCard = 0L;
        LogicalOperatorTag tag = grpByDistinctOp.getOperatorTag();
        if (tag == LogicalOperatorTag.DISTINCT || tag == LogicalOperatorTag.GROUP) {
            ILogicalOperator parent = this.joinEnum.findDataSourceScanOperatorParent(grpByDistinctOp);
            DataSourceScanOperator scanOp = (DataSourceScanOperator)((Mutable)parent.getInputs().get(0)).getValue();
            if (scanOp == null) {
                return distinctCard;
            }
            Index index = this.findSampleIndex(scanOp, this.optCtx);
            if (index == null) {
                return distinctCard;
            }
            Index.SampleIndexDetails idxDetails = (Index.SampleIndexDetails)index.getIndexDetails();
            double origDatasetCard = idxDetails.getSourceCardinality();
            byte dsType = ((DataSource)scanOp.getDataSource()).getDatasourceType();
            if (dsType != 0 && dsType != 1) {
                return distinctCard;
            }
            SampleDataSource sampleDataSource = this.joinEnum.getSampleDataSource(scanOp);
            ILogicalOperator parentOfSelectOp = this.findParentOfSelectOp(grpByDistinctOp);
            SelectOperator selOp = parentOfSelectOp == null ? null : (SelectOperator)((Mutable)parentOfSelectOp.getInputs().get(0)).getValue();
            this.setTotalCardFromSample(idxDetails.getSampleCardinalityTarget());
            if (selOp != null) {
                long sampleWithPredicates = this.findSampleSizeWithPredicates(selOp, sampleDataSource);
                this.setTotalCardFromSample(sampleWithPredicates);
            }
            distinctCard = this.findEstDistinctWithPredicates(grpByDistinctOp, origDatasetCard, sampleDataSource);
        }
        return distinctCard;
    }

    private long findSampleSizeWithPredicates(SelectOperator selOp, SampleDataSource sampleDataSource) throws AlgebricksException {
        long sampleSize = Long.MAX_VALUE;
        ILogicalOperator copyOfSelOp = OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)selOp);
        if (this.setSampleDataSource(copyOfSelOp, sampleDataSource)) {
            List<List<IAObject>> result = this.runSamplingQuery(this.optCtx, copyOfSelOp);
            sampleSize = (long)this.findPredicateCardinality(result, false);
        }
        return sampleSize;
    }

    private long findEstDistinctWithPredicates(ILogicalOperator grpByDistinctOp, double origDatasetCardinality, SampleDataSource sampleDataSource) throws AlgebricksException {
        ILogicalOperator copyOfGrpByDistinctOp;
        double estDistCardinalityFromSample = -1.0;
        double estDistCardinality = -1.0;
        LogicalOperatorTag tag = grpByDistinctOp.getOperatorTag();
        if ((tag == LogicalOperatorTag.GROUP || tag == LogicalOperatorTag.DISTINCT) && this.setSampleDataSource(copyOfGrpByDistinctOp = OperatorManipulationUtil.bottomUpCopyOperators((ILogicalOperator)grpByDistinctOp), sampleDataSource)) {
            List<List<IAObject>> result = this.runSamplingQuery(this.optCtx, copyOfGrpByDistinctOp);
            estDistCardinalityFromSample = this.findPredicateCardinality(result, false);
        }
        if (estDistCardinalityFromSample != -1.0) {
            estDistCardinality = this.distinctEstimator(estDistCardinalityFromSample, origDatasetCardinality);
        }
        estDistCardinality = Math.max(0.0, estDistCardinality);
        return Math.round(estDistCardinality);
    }

    private double distinctEstimator(double estDistinctCardinalityFromSample, double origDatasetCardinality) {
        double estDistinctCardinality = this.initNR(estDistinctCardinalityFromSample);
        this.setDistinctCardFromSample(estDistinctCardinality);
        int max_counter = 1000;
        double denominator = this.derivativeFunctionForMMO(estDistinctCardinality);
        if (denominator == 0.0) {
            return estDistinctCardinality;
        }
        double fraction = this.functionForMMO(estDistinctCardinality) / denominator;
        for (int itr_counter = 0; Math.abs(fraction) >= 0.001 && itr_counter < max_counter && (denominator = this.derivativeFunctionForMMO(estDistinctCardinality)) != 0.0; ++itr_counter) {
            fraction = this.functionForMMO(estDistinctCardinality) / denominator;
            estDistinctCardinality -= fraction;
            if (!(estDistinctCardinality > origDatasetCardinality)) continue;
            estDistinctCardinality = origDatasetCardinality;
            break;
        }
        estDistinctCardinality = Math.max(estDistinctCardinality, estDistinctCardinalityFromSample);
        return estDistinctCardinality;
    }

    double initNR(double estDistinctCardinalityFromSample) {
        double estDistinctCardinality = estDistinctCardinalityFromSample;
        if (this.totalCardFromSample <= 1L) {
            this.setTotalCardFromSample(this.totalCardFromSample + 2L);
            estDistinctCardinality = this.totalCardFromSample - 1L;
        } else if (estDistinctCardinality == (double)this.totalCardFromSample) {
            estDistinctCardinality -= 1.0;
        }
        return estDistinctCardinality;
    }

    private double functionForMMO(double x) {
        return x * (1.0 - Math.exp(-1.0 * (double)this.totalCardFromSample / x)) - this.distinctCardFromSample;
    }

    private double derivativeFunctionForMMO(double x) {
        double arg = (double)this.totalCardFromSample / x;
        return 1.0 - (arg + 1.0) * Math.exp(-1.0 * arg);
    }

    private boolean setSampleDataSource(ILogicalOperator op, SampleDataSource sampleDataSource) {
        ILogicalOperator parent = this.joinEnum.findDataSourceScanOperatorParent(op);
        DataSourceScanOperator scanOp = (DataSourceScanOperator)((Mutable)parent.getInputs().get(0)).getValue();
        if (scanOp == null) {
            return false;
        }
        scanOp.setDataSource((IDataSource)sampleDataSource);
        return true;
    }

    private ILogicalOperator findParentOfSelectOp(ILogicalOperator op) {
        ILogicalOperator parent = null;
        ILogicalOperator currentOp = op;
        LogicalOperatorTag tag = currentOp.getOperatorTag();
        while (tag != LogicalOperatorTag.DATASOURCESCAN) {
            if (tag == LogicalOperatorTag.SELECT) {
                return parent;
            }
            parent = currentOp;
            currentOp = (ILogicalOperator)((Mutable)currentOp.getInputs().get(0)).getValue();
            tag = currentOp.getOperatorTag();
        }
        return null;
    }
}

