/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.DatasetDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.visitor.DefUseChainComputerVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SwitchOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class PushdownOperatorVisitor
implements ILogicalOperatorVisitor<Void, Void> {
    private static final List<LogicalVariable> EMPTY_VARIABLES = Collections.emptyList();
    private final PushdownContext pushdownContext;
    private final IOptimizationContext context;
    private final DefUseChainComputerVisitor defUseComputer;
    private final Set<ILogicalOperator> visitedOperators;

    public PushdownOperatorVisitor(PushdownContext pushdownContext, IOptimizationContext context) {
        this.pushdownContext = pushdownContext;
        this.context = context;
        this.defUseComputer = new DefUseChainComputerVisitor(pushdownContext);
        this.visitedOperators = new HashSet<ILogicalOperator>();
    }

    private void visitInputs(ILogicalOperator op, List<LogicalVariable> producedVariables) throws AlgebricksException {
        if (this.visitedOperators.contains(op)) {
            return;
        }
        for (Mutable child : op.getInputs()) {
            ((ILogicalOperator)child.getValue()).accept((ILogicalOperatorVisitor)this, null);
        }
        this.visitedOperators.add(op);
        this.pushdownContext.enterScope(op);
        this.defUseComputer.init(op, producedVariables);
        op.acceptExpressionTransform((ILogicalExpressionReferenceTransform)this.defUseComputer);
        if (op.getOperatorTag() == LogicalOperatorTag.UNIONALL) {
            UnionAllOperator unionOp = (UnionAllOperator)op;
            for (Triple vars : unionOp.getVariableMappings()) {
                VariableReferenceExpression left = new VariableReferenceExpression((LogicalVariable)vars.first);
                this.pushdownContext.use(op, (ILogicalExpression)left, -1, null);
                VariableReferenceExpression right = new VariableReferenceExpression((LogicalVariable)vars.second);
                this.pushdownContext.use(op, (ILogicalExpression)right, -1, null);
            }
        }
    }

    public Void visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        this.setEmptyRecord((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue(), op.getVariables());
        return null;
    }

    public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        DatasetDataSource datasetDataSource = this.getDatasetDataSourceIfApplicable((DataSource)op.getDataSource());
        this.registerDatasetIfApplicable(datasetDataSource, (AbstractScanOperator)op);
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        DatasetDataSource datasetDataSource = this.getDatasetDataSourceIfApplicable(this.getDataSourceFromUnnestMapOperator((AbstractUnnestMapOperator)op));
        this.registerDatasetIfApplicable(datasetDataSource, (AbstractScanOperator)op);
        return null;
    }

    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        DatasetDataSource datasetDataSource = this.getDatasetDataSourceIfApplicable(this.getDataSourceFromUnnestMapOperator((AbstractUnnestMapOperator)op));
        this.registerDatasetIfApplicable(datasetDataSource, (AbstractScanOperator)op);
        return null;
    }

    public Void visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        if (!op.isGlobal() && this.isCountConstant(op.getExpressions())) {
            this.setEmptyRecord((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue(), EMPTY_VARIABLES);
        }
        return null;
    }

    public Void visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        return null;
    }

    private DatasetDataSource getDatasetDataSourceIfApplicable(DataSource dataSource) throws AlgebricksException {
        if (dataSource == null || dataSource.getDatasourceType() == 5 || !(dataSource instanceof DatasetDataSource)) {
            return null;
        }
        Dataset dataset = this.getDataset(dataSource);
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL && dataset.getDatasetFormatInfo().getFormat() == DatasetConfig.DatasetFormat.ROW) {
            return null;
        }
        return (DatasetDataSource)dataSource;
    }

    private Dataset getDataset(DataSource dataSource) throws AlgebricksException {
        MetadataProvider mp = (MetadataProvider)this.context.getMetadataProvider();
        DataverseName dataverse = dataSource.getId().getDataverseName();
        String datasetName = dataSource.getId().getDatasourceName();
        String database = dataSource.getId().getDatabaseName();
        return mp.findDataset(database, dataverse, datasetName);
    }

    private DataSource getDataSourceFromUnnestMapOperator(AbstractUnnestMapOperator unnest) throws AlgebricksException {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)unnest.getExpressionRef().getValue();
        String dataverse = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)3);
        String dataset = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)4);
        if (!ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)0).equals(dataset)) {
            return null;
        }
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverse);
        String database = ConstantExpressionUtil.getStringArgument((AbstractFunctionCallExpression)funcExpr, (int)2);
        DataSourceId dsid = new DataSourceId(database, dataverseName, dataset);
        MetadataProvider metadataProvider = (MetadataProvider)this.context.getMetadataProvider();
        return metadataProvider.findDataSource(dsid);
    }

    private void registerDatasetIfApplicable(DatasetDataSource datasetDataSource, AbstractScanOperator op) throws AlgebricksException {
        if (datasetDataSource != null) {
            Dataset dataset = this.getDataset((DataSource)datasetDataSource);
            List primaryKeyVariables = datasetDataSource.getPrimaryKeyVariables(op.getVariables());
            LogicalVariable recordVar = datasetDataSource.getDataRecordVariable(op.getVariables());
            LogicalVariable metaVar = datasetDataSource.getMetaVariable(op.getVariables());
            this.pushdownContext.registerScan(dataset, primaryKeyVariables, recordVar, metaVar, op);
        }
    }

    private void setEmptyRecord(ILogicalOperator inputOp, List<LogicalVariable> retainedVariables) throws AlgebricksException {
        Mutable selectCondition;
        List variables;
        DataSource dataSource;
        LogicalOperatorTag tag = inputOp.getOperatorTag();
        if (tag != LogicalOperatorTag.DATASOURCESCAN && tag != LogicalOperatorTag.UNNEST_MAP) {
            return;
        }
        if (inputOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            DataSourceScanOperator scan = (DataSourceScanOperator)inputOp;
            dataSource = (DataSource)scan.getDataSource();
            variables = scan.getVariables();
            selectCondition = scan.getSelectCondition();
        } else {
            UnnestMapOperator unnest = (UnnestMapOperator)inputOp;
            dataSource = this.getDataSourceFromUnnestMapOperator((AbstractUnnestMapOperator)unnest);
            variables = unnest.getVariables();
            selectCondition = unnest.getSelectCondition();
        }
        DatasetDataSource datasetDataSource = this.getDatasetDataSourceIfApplicable(dataSource);
        if (datasetDataSource == null) {
            return;
        }
        HashSet selectConditionVariables = new HashSet();
        if (selectCondition != null) {
            ((ILogicalExpression)selectCondition.getValue()).getUsedVariables(selectConditionVariables);
        }
        LogicalVariable recordVar = datasetDataSource.getDataRecordVariable(variables);
        ScanDefineDescriptor scanDefDesc = (ScanDefineDescriptor)this.pushdownContext.getDefineDescriptor(recordVar);
        if (!retainedVariables.contains(recordVar) && !selectConditionVariables.contains(recordVar)) {
            scanDefDesc.setRecordNode(RootExpectedSchemaNode.EMPTY_ROOT_NODE);
        }
        if (scanDefDesc.hasMeta() && !retainedVariables.contains(scanDefDesc.getMetaRecordVariable())) {
            scanDefDesc.setMetaNode(RootExpectedSchemaNode.EMPTY_ROOT_NODE);
        }
    }

    private boolean isCountConstant(List<Mutable<ILogicalExpression>> expressions) {
        if (expressions.size() != 1) {
            return false;
        }
        ILogicalExpression expression = (ILogicalExpression)expressions.get(0).getValue();
        if (expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        return BuiltinFunctions.SQL_COUNT.equals((Object)fid) && ((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT;
    }

    private void visitNestedPlans(ILogicalOperator op, List<ILogicalPlan> nestedPlans) throws AlgebricksException {
        ILogicalOperator previousSubplanOp = this.pushdownContext.enterSubplan(op);
        for (ILogicalPlan plan : nestedPlans) {
            for (Mutable root : plan.getRoots()) {
                ((ILogicalOperator)root.getValue()).accept((ILogicalOperatorVisitor)this, null);
            }
        }
        this.pushdownContext.exitSubplan(previousSubplanOp);
    }

    public Void visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        this.visitNestedPlans((ILogicalOperator)op, op.getNestedPlans());
        return null;
    }

    public Void visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        return null;
    }

    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        return null;
    }

    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return null;
    }

    public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op, op.getVariables());
        this.visitNestedPlans((ILogicalOperator)op, op.getNestedPlans());
        return null;
    }

    public Void visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSwitchOperator(SwitchOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        return null;
    }

    public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        this.visitInputs((ILogicalOperator)op);
        this.visitNestedPlans((ILogicalOperator)op, op.getNestedPlans());
        return null;
    }

    private void visitInputs(ILogicalOperator op) throws AlgebricksException {
        this.visitInputs(op, null);
    }
}

