/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import java.util.List;
import java.util.Map;
import org.apache.asterix.app.message.AtomicJobRollbackCompleteMessage;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.IndexCheckpoint;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AtomicJobRollbackMessage
implements INcAddressedMessage {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final List<Integer> datasetIds;
    private final Map<String, ILSMComponentId> componentIdMap;
    private static final Logger LOGGER = LogManager.getLogger();

    public AtomicJobRollbackMessage(JobId jobId, List<Integer> datasetIds, Map<String, ILSMComponentId> componentIdMap) {
        this.jobId = jobId;
        this.datasetIds = datasetIds;
        this.componentIdMap = componentIdMap;
    }

    public void handle(INcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        IDatasetLifecycleManager datasetLifecycleManager = appCtx.getDatasetLifecycleManager();
        IIndexCheckpointManagerProvider indexCheckpointManagerProvider = datasetLifecycleManager.getIndexCheckpointManagerProvider();
        this.componentIdMap.forEach((k, v) -> {
            try {
                IndexCheckpoint checkpoint;
                IIndexCheckpointManager checkpointManager = indexCheckpointManagerProvider.get(ResourceReference.ofIndex((String)k));
                if (checkpointManager.getCheckpointCount() > 0 && (checkpoint = checkpointManager.getLatest()).getLastComponentId() == v.getMaxId()) {
                    LOGGER.info("Removing checkpoint for resource {} for component id {}", k, (Object)checkpoint.getLastComponentId());
                    checkpointManager.deleteLatest(v.getMaxId(), 1);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while rolling back atomic statement for {}, halting JVM", (Object)this.jobId);
                ExitUtil.halt((int)24);
            }
        });
        AtomicJobRollbackCompleteMessage message = new AtomicJobRollbackCompleteMessage(this.jobId, appCtx.getServiceContext().getNodeId());
        NCMessageBroker mb = (NCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        try {
            mb.sendRealTimeMessageToPrimaryCC(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "AtomicJobRollbackMessage{jobId=" + this.jobId + ", datasetIds=" + this.datasetIds + "}";
    }
}

